/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.spi.descriptor.xml;

import java.util.List;
import org.apache.deltaspike.jpa.spi.descriptor.xml.AbstractEntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.EntityDescriptor;
import org.apache.deltaspike.jpa.spi.descriptor.xml.MappedSuperclassDescriptor;

public final class AbstractEntityHierarchyBuilder {
    private AbstractEntityHierarchyBuilder() {
    }

    public static void buildHierarchy(List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
        for (EntityDescriptor descriptor : entities) {
            AbstractEntityHierarchyBuilder.buildHierarchy(descriptor, entities, superClasses);
        }
    }

    protected static void buildHierarchy(AbstractEntityDescriptor descriptor, List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
        for (Class<?> superClass = descriptor.getEntityClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            AbstractEntityDescriptor superDescriptor = AbstractEntityHierarchyBuilder.findPersistentClassDescriptor(superClass, entities, superClasses);
            if (superDescriptor == null) continue;
            if (descriptor.getParent() == null) {
                AbstractEntityHierarchyBuilder.buildHierarchy(superDescriptor, entities, superClasses);
            }
            descriptor.setParent(superDescriptor);
            return;
        }
    }

    protected static AbstractEntityDescriptor findPersistentClassDescriptor(Class<?> superClass, List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
        for (MappedSuperclassDescriptor mappedSuperclassDescriptor : superClasses) {
            if (!mappedSuperclassDescriptor.getEntityClass().equals(superClass)) continue;
            return mappedSuperclassDescriptor;
        }
        for (EntityDescriptor entityDescriptor : entities) {
            if (!entityDescriptor.getEntityClass().equals(superClass)) continue;
            return entityDescriptor;
        }
        return null;
    }
}

