/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestGrammar;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseContainer;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseStates;
import org.apache.directory.api.ldap.codec.controls.sort.StoreSortResponseResultCode;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortResponseGrammar
extends AbstractGrammar<SortResponseContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SortRequestGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<SortResponseContainer> instance = new SortResponseGrammar();

    private SortResponseGrammar() {
        this.setName(SortResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[SortResponseStates.END_STATE.ordinal()][256];
        this.transitions[SortResponseStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)SortResponseStates.START_STATE, (Enum)SortResponseStates.SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[SortResponseStates.SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)SortResponseStates.SEQUENCE_STATE, (Enum)SortResponseStates.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), new StoreSortResponseResultCode());
        this.transitions[SortResponseStates.RESULT_CODE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SortResponseStates.RESULT_CODE_STATE, (Enum)SortResponseStates.AT_DESC_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SortResponseContainer>(){

            public void action(SortResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String atType = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("AttributeType = " + atType);
                }
                container.getControl().setAttributeName(atType);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

