/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;

public class DeepTrimToLowerNormalizer
extends Normalizer {
    public DeepTrimToLowerNormalizer(String oid) {
        super(oid);
    }

    public DeepTrimToLowerNormalizer() {
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        if (value == null) {
            return null;
        }
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.CASE_IGNORE);
            return new StringValue(normalized);
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{value}), ioe);
        }
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (value == null) {
            return null;
        }
        try {
            return PrepareString.normalize(value, PrepareString.StringType.CASE_IGNORE);
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{value}), ioe);
        }
    }
}

