/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyRequestDecoder;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordModifyRequestDecorator
extends ExtendedRequestDecorator<PasswordModifyRequest>
implements PasswordModifyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordModifyRequestDecorator.class);
    private PasswordModifyRequest passwordModifyRequest;
    private int requestLength = 0;

    public PasswordModifyRequestDecorator(LdapApiService codec, PasswordModifyRequest decoratedMessage) {
        super(codec, (ExtendedRequest)decoratedMessage);
        this.passwordModifyRequest = decoratedMessage;
    }

    public void setRequestValue(byte[] requestValue) {
        PasswordModifyRequestDecoder decoder = new PasswordModifyRequestDecoder();
        try {
            if (requestValue != null) {
                this.passwordModifyRequest = decoder.decode(requestValue);
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.encodeInternal().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public PasswordModifyResponse getResultResponse() {
        return (PasswordModifyResponse)this.passwordModifyRequest.getResultResponse();
    }

    public byte[] getUserIdentity() {
        return this.passwordModifyRequest.getUserIdentity();
    }

    public void setUserIdentity(byte[] userIdentity) {
        this.passwordModifyRequest.setUserIdentity(userIdentity);
    }

    public byte[] getOldPassword() {
        return this.passwordModifyRequest.getOldPassword();
    }

    public void setOldPassword(byte[] oldPassword) {
        this.passwordModifyRequest.setOldPassword(oldPassword);
    }

    public byte[] getNewPassword() {
        return this.passwordModifyRequest.getNewPassword();
    }

    public void setNewPassword(byte[] newPassword) {
        this.passwordModifyRequest.setNewPassword(newPassword);
    }

    int computeLengthInternal() {
        int len;
        this.requestLength = 0;
        if (this.passwordModifyRequest.getUserIdentity() != null) {
            len = this.passwordModifyRequest.getUserIdentity().length;
            this.requestLength = 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.passwordModifyRequest.getOldPassword() != null) {
            len = this.passwordModifyRequest.getOldPassword().length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        if (this.passwordModifyRequest.getNewPassword() != null) {
            len = this.passwordModifyRequest.getNewPassword().length;
            this.requestLength += 1 + TLV.getNbBytes((int)len) + len;
        }
        return 1 + TLV.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    ByteBuffer encodeInternal() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLengthInternal());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(TLV.getBytes((int)this.requestLength));
        if (this.passwordModifyRequest.getUserIdentity() != null) {
            byte[] userIdentity = this.passwordModifyRequest.getUserIdentity();
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)userIdentity.length));
            bb.put(userIdentity);
        }
        if (this.passwordModifyRequest.getOldPassword() != null) {
            byte[] oldPassword = this.passwordModifyRequest.getOldPassword();
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)oldPassword.length));
            bb.put(oldPassword);
        }
        if (this.passwordModifyRequest.getNewPassword() != null) {
            byte[] newPassword = this.passwordModifyRequest.getNewPassword();
            bb.put((byte)-126);
            bb.put(TLV.getBytes((int)newPassword.length));
            bb.put(newPassword);
        }
        return bb;
    }
}

