/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.util.Map;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.proxiedauthz.ProxiedAuthzFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdShowDeletedFactory;
import org.apache.directory.api.ldap.extras.controls.changeNotifications_impl.ChangeNotificationsFactory;
import org.apache.directory.api.ldap.extras.controls.permissiveModify_impl.PermissiveModifyFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTls.StartTlsFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CodecFactoryUtil.class);

    private CodecFactoryUtil() {
    }

    public static void loadStockControls(Map<String, ControlFactory<?>> controlFactories, LdapApiService apiService) {
        CascadeFactory cascadeFactory = new CascadeFactory(apiService);
        controlFactories.put(cascadeFactory.getOid(), (ControlFactory<?>)cascadeFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)cascadeFactory.getOid());
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(apiService);
        controlFactories.put(entryChangeFactory.getOid(), (ControlFactory<?>)entryChangeFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)entryChangeFactory.getOid());
        ManageDsaITFactory manageDsaITFactory = new ManageDsaITFactory(apiService);
        controlFactories.put(manageDsaITFactory.getOid(), (ControlFactory<?>)manageDsaITFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)manageDsaITFactory.getOid());
        ProxiedAuthzFactory proxiedAuthzFactory = new ProxiedAuthzFactory(apiService);
        controlFactories.put(proxiedAuthzFactory.getOid(), (ControlFactory<?>)proxiedAuthzFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)proxiedAuthzFactory.getOid());
        PagedResultsFactory pagedResultsFactory = new PagedResultsFactory(apiService);
        controlFactories.put(pagedResultsFactory.getOid(), (ControlFactory<?>)pagedResultsFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)pagedResultsFactory.getOid());
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(apiService);
        controlFactories.put(persistentSearchFactory.getOid(), (ControlFactory<?>)persistentSearchFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)persistentSearchFactory.getOid());
        SubentriesFactory subentriesFactory = new SubentriesFactory(apiService);
        controlFactories.put(subentriesFactory.getOid(), (ControlFactory<?>)subentriesFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)subentriesFactory.getOid());
        PasswordPolicyFactory passwordPolicyFactory = new PasswordPolicyFactory(apiService);
        controlFactories.put(passwordPolicyFactory.getOid(), (ControlFactory<?>)passwordPolicyFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)passwordPolicyFactory.getOid());
        VirtualListViewRequestFactory virtualListViewRequestFactory = new VirtualListViewRequestFactory(apiService);
        controlFactories.put(virtualListViewRequestFactory.getOid(), (ControlFactory<?>)virtualListViewRequestFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)virtualListViewRequestFactory.getOid());
        VirtualListViewResponseFactory virtualListViewResponseFactory = new VirtualListViewResponseFactory(apiService);
        controlFactories.put(virtualListViewResponseFactory.getOid(), (ControlFactory<?>)virtualListViewResponseFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)virtualListViewResponseFactory.getOid());
        SyncDoneValueFactory syncDoneValueFactory = new SyncDoneValueFactory(apiService);
        controlFactories.put(syncDoneValueFactory.getOid(), (ControlFactory<?>)syncDoneValueFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)syncDoneValueFactory.getOid());
        SyncInfoValueFactory syncInfoValueFactory = new SyncInfoValueFactory(apiService);
        controlFactories.put(syncInfoValueFactory.getOid(), (ControlFactory<?>)syncInfoValueFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)syncInfoValueFactory.getOid());
        SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(apiService);
        controlFactories.put(syncRequestValueFactory.getOid(), (ControlFactory<?>)syncRequestValueFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)syncRequestValueFactory.getOid());
        SyncStateValueFactory syncStateValueFactory = new SyncStateValueFactory(apiService);
        controlFactories.put(syncStateValueFactory.getOid(), (ControlFactory<?>)syncStateValueFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)syncStateValueFactory.getOid());
        SortRequestFactory sortRequestFactory = new SortRequestFactory(apiService);
        controlFactories.put(sortRequestFactory.getOid(), (ControlFactory<?>)sortRequestFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)sortRequestFactory.getOid());
        SortResponseFactory sortResponseFactory = new SortResponseFactory(apiService);
        controlFactories.put(sortResponseFactory.getOid(), (ControlFactory<?>)sortResponseFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)sortResponseFactory.getOid());
        AdDirSyncFactory adDirSyncFactory = new AdDirSyncFactory(apiService);
        controlFactories.put(adDirSyncFactory.getOid(), (ControlFactory<?>)adDirSyncFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)adDirSyncFactory.getOid());
        AdShowDeletedFactory adDeletedFactory = new AdShowDeletedFactory(apiService);
        controlFactories.put(adDeletedFactory.getOid(), (ControlFactory<?>)adDeletedFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)adDeletedFactory.getOid());
        PermissiveModifyFactory permissiveModifyFactory = new PermissiveModifyFactory(apiService);
        controlFactories.put(permissiveModifyFactory.getOid(), (ControlFactory<?>)permissiveModifyFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)permissiveModifyFactory.getOid());
        ChangeNotificationsFactory changeNotificationsFactory = new ChangeNotificationsFactory(apiService);
        controlFactories.put(changeNotificationsFactory.getOid(), (ControlFactory<?>)changeNotificationsFactory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)changeNotificationsFactory.getOid());
    }

    public static void loadStockExtendedOperations(Map<String, ExtendedOperationFactory> extendendOperationsFactories, LdapApiService apiService) {
        CancelFactory cancelFactory = new CancelFactory(apiService);
        extendendOperationsFactories.put(cancelFactory.getOid(), (ExtendedOperationFactory)cancelFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)cancelFactory.getOid());
        CertGenerationFactory certGenerationFactory = new CertGenerationFactory(apiService);
        extendendOperationsFactories.put(certGenerationFactory.getOid(), (ExtendedOperationFactory)certGenerationFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)certGenerationFactory.getOid());
        GracefulShutdownFactory gracefulShutdownFactory = new GracefulShutdownFactory(apiService);
        extendendOperationsFactories.put(gracefulShutdownFactory.getOid(), (ExtendedOperationFactory)gracefulShutdownFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)gracefulShutdownFactory.getOid());
        StoredProcedureFactory storedProcedureFactory = new StoredProcedureFactory(apiService);
        extendendOperationsFactories.put(storedProcedureFactory.getOid(), (ExtendedOperationFactory)storedProcedureFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)storedProcedureFactory.getOid());
        GracefulDisconnectFactory gracefulDisconnectFactory = new GracefulDisconnectFactory(apiService);
        extendendOperationsFactories.put(gracefulDisconnectFactory.getOid(), (ExtendedOperationFactory)gracefulDisconnectFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)gracefulDisconnectFactory.getOid());
        PasswordModifyFactory passwordModifyFactory = new PasswordModifyFactory(apiService);
        extendendOperationsFactories.put(passwordModifyFactory.getOid(), (ExtendedOperationFactory)passwordModifyFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)passwordModifyFactory.getOid());
        WhoAmIFactory whoAmIFactory = new WhoAmIFactory(apiService);
        extendendOperationsFactories.put(whoAmIFactory.getOid(), (ExtendedOperationFactory)whoAmIFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)whoAmIFactory.getOid());
        StartTlsFactory startTlsFactory = new StartTlsFactory(apiService);
        extendendOperationsFactories.put(startTlsFactory.getOid(), (ExtendedOperationFactory)startTlsFactory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)startTlsFactory.getOid());
    }
}

