/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.DeepTrimNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepTrimComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DeepTrimComparator.class);

    public DeepTrimComparator(String oid) {
        super(oid);
        this.normalizer = new DeepTrimNormalizer();
    }

    @Override
    public int compare(String o1, String o2) {
        String n2;
        String n1 = o1;
        try {
            n1 = this.normalizer.normalize(o1);
        }
        catch (LdapException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg(I18n.MSG_13700_FAILED_TO_NORMALIZE, o1), (Throwable)e);
            }
            n1 = o1;
        }
        try {
            n2 = this.normalizer.normalize(o2);
        }
        catch (LdapException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(I18n.msg(I18n.MSG_13700_FAILED_TO_NORMALIZE, o2), (Throwable)e);
            }
            n2 = o2;
        }
        return n1.compareTo(n2);
    }
}

