/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.LimitExceededException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapAdminLimitExceededException;
import org.apache.directory.api.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.api.ldap.model.exception.LdapAliasDereferencingException;
import org.apache.directory.api.ldap.model.exception.LdapAliasException;
import org.apache.directory.api.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.api.ldap.model.exception.LdapCannotCancelException;
import org.apache.directory.api.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.api.ldap.model.exception.LdapEntryAlreadyExistsException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidSearchFilterException;
import org.apache.directory.api.ldap.model.exception.LdapLoopDetectedException;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapProtocolErrorException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaViolationException;
import org.apache.directory.api.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.api.ldap.model.exception.LdapSizeLimitExceededException;
import org.apache.directory.api.ldap.model.exception.LdapStrongAuthenticationRequiredException;
import org.apache.directory.api.ldap.model.exception.LdapTimeLimitExceededException;
import org.apache.directory.api.ldap.model.exception.LdapTooLateException;
import org.apache.directory.api.ldap.model.exception.LdapUnknownException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;

public enum ResultCodeEnum {
    SUCCESS(0, "success"),
    PARTIAL_RESULTS(9, "partialResults"),
    COMPARE_FALSE(5, "compareFalse"),
    COMPARE_TRUE(6, "compareTrue"),
    REFERRAL(10, "referral"),
    SASL_BIND_IN_PROGRESS(14, "saslBindInProgress"),
    AUTH_METHOD_NOT_SUPPORTED(7, "authMethodNotSupported"),
    STRONG_AUTH_REQUIRED(8, "strongAuthRequired"),
    CONFIDENTIALITY_REQUIRED(13, "confidentialityRequired"),
    ALIAS_DEREFERENCING_PROBLEM(36, "aliasDereferencingProblem"),
    INAPPROPRIATE_AUTHENTICATION(48, "inappropriateAuthentication"),
    INVALID_CREDENTIALS(49, "invalidCredentials"),
    INSUFFICIENT_ACCESS_RIGHTS(50, "insufficientAccessRights"),
    OPERATIONS_ERROR(1, "operationsError"),
    PROTOCOL_ERROR(2, "protocolError"),
    TIME_LIMIT_EXCEEDED(3, "timeLimitExceeded"),
    SIZE_LIMIT_EXCEEDED(4, "sizeLimitExceeded"),
    ADMIN_LIMIT_EXCEEDED(11, "adminLimitExceeded"),
    UNAVAILABLE_CRITICAL_EXTENSION(12, "unavailableCriticalExtension"),
    BUSY(51, "busy"),
    UNAVAILABLE(52, "unavailable"),
    UNWILLING_TO_PERFORM(53, "unwillingToPerform"),
    LOOP_DETECT(54, "loopDetect"),
    NO_SUCH_ATTRIBUTE(16, "noSuchAttribute"),
    UNDEFINED_ATTRIBUTE_TYPE(17, "undefinedAttributeType"),
    INAPPROPRIATE_MATCHING(18, "inappropriateMatching"),
    CONSTRAINT_VIOLATION(19, "constraintViolation"),
    ATTRIBUTE_OR_VALUE_EXISTS(20, "attributeOrValueExists"),
    INVALID_ATTRIBUTE_SYNTAX(21, "invalidAttributeSyntax"),
    NO_SUCH_OBJECT(32, "noSuchObject"),
    ALIAS_PROBLEM(33, "aliasProblem"),
    INVALID_DN_SYNTAX(34, "invalidDNSyntax"),
    NAMING_VIOLATION(64, "namingViolation"),
    OBJECT_CLASS_VIOLATION(65, "objectClassViolation"),
    NOT_ALLOWED_ON_NON_LEAF(66, "notAllowedOnNonLeaf"),
    NOT_ALLOWED_ON_RDN(67, "notAllowedOnRDN"),
    ENTRY_ALREADY_EXISTS(68, "entryAlreadyExists"),
    OBJECT_CLASS_MODS_PROHIBITED(69, "objectClassModsProhibited"),
    AFFECTS_MULTIPLE_DSAS(71, "affectsMultipleDSAs"),
    OTHER(80, "other"),
    CANCELED(118, "canceled"),
    NO_SUCH_OPERATION(119, "noSuchOperation"),
    TOO_LATE(120, "tooLate"),
    CANNOT_CANCEL(121, "cannotCancel"),
    E_SYNC_REFRESH_REQUIRED(4096, "eSyncRefreshRequired"),
    UNKNOWN(122, "unknown");

    private int value;
    private String message;
    private static final Set<ResultCodeEnum> EMPTY_RESULT_CODE_SET;
    private static final Set<ResultCodeEnum> NON_ERRONEOUS_CODES;
    private static final Set<ResultCodeEnum> BIND_CODES;
    private static final Set<ResultCodeEnum> SEARCH_CODES;
    private static final Set<ResultCodeEnum> MODIFY_CODES;
    private static final Set<ResultCodeEnum> ADD_CODES;
    private static final Set<ResultCodeEnum> DELETE_CODES;
    private static final Set<ResultCodeEnum> MODIFYDN_CODES;
    private static final Set<ResultCodeEnum> COMPARE_CODES;
    private static final Set<ResultCodeEnum> EXTENDED_CODES;
    private static final Set<ResultCodeEnum> NAMING_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> AUTHENTICATION_NOT_SUPPORTED_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> SERVICE_UNAVAILABLE_CODES;
    private static final Set<ResultCodeEnum> INVALID_ATTRIBUTE_VALUE_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> PARTIAL_RESULTS_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> LIMIT_EXCEEDED_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> OPERATION_NOT_SUPPORTED_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> INVALID_NAME_EXCEPTION_CODES;
    private static final Set<ResultCodeEnum> SCHEMA_VIOLATION_EXCEPTION_CODES;

    private ResultCodeEnum(int value, String message) {
        this.value = value;
        this.message = message;
    }

    public int getValue() {
        return this.value;
    }

    public String getMessage() {
        return this.message;
    }

    public int getResultCode() {
        return this.value;
    }

    public static ResultCodeEnum getResultCode(int value) {
        switch (value) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONS_ERROR;
            }
            case 2: {
                return PROTOCOL_ERROR;
            }
            case 3: {
                return TIME_LIMIT_EXCEEDED;
            }
            case 4: {
                return SIZE_LIMIT_EXCEEDED;
            }
            case 5: {
                return COMPARE_FALSE;
            }
            case 6: {
                return COMPARE_TRUE;
            }
            case 7: {
                return AUTH_METHOD_NOT_SUPPORTED;
            }
            case 8: {
                return STRONG_AUTH_REQUIRED;
            }
            case 9: {
                return PARTIAL_RESULTS;
            }
            case 10: {
                return REFERRAL;
            }
            case 11: {
                return ADMIN_LIMIT_EXCEEDED;
            }
            case 12: {
                return UNAVAILABLE_CRITICAL_EXTENSION;
            }
            case 13: {
                return CONFIDENTIALITY_REQUIRED;
            }
            case 14: {
                return SASL_BIND_IN_PROGRESS;
            }
            case 16: {
                return NO_SUCH_ATTRIBUTE;
            }
            case 17: {
                return UNDEFINED_ATTRIBUTE_TYPE;
            }
            case 18: {
                return INAPPROPRIATE_MATCHING;
            }
            case 19: {
                return CONSTRAINT_VIOLATION;
            }
            case 20: {
                return ATTRIBUTE_OR_VALUE_EXISTS;
            }
            case 21: {
                return INVALID_ATTRIBUTE_SYNTAX;
            }
            case 32: {
                return NO_SUCH_OBJECT;
            }
            case 33: {
                return ALIAS_PROBLEM;
            }
            case 34: {
                return INVALID_DN_SYNTAX;
            }
            case 35: {
                return UNKNOWN;
            }
            case 36: {
                return ALIAS_DEREFERENCING_PROBLEM;
            }
            case 48: {
                return INAPPROPRIATE_AUTHENTICATION;
            }
            case 49: {
                return INVALID_CREDENTIALS;
            }
            case 50: {
                return INSUFFICIENT_ACCESS_RIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 52: {
                return UNAVAILABLE;
            }
            case 53: {
                return UNWILLING_TO_PERFORM;
            }
            case 54: {
                return LOOP_DETECT;
            }
            case 64: {
                return NAMING_VIOLATION;
            }
            case 65: {
                return OBJECT_CLASS_VIOLATION;
            }
            case 66: {
                return NOT_ALLOWED_ON_NON_LEAF;
            }
            case 67: {
                return NOT_ALLOWED_ON_RDN;
            }
            case 68: {
                return ENTRY_ALREADY_EXISTS;
            }
            case 69: {
                return OBJECT_CLASS_MODS_PROHIBITED;
            }
            case 71: {
                return AFFECTS_MULTIPLE_DSAS;
            }
            case 80: {
                return OTHER;
            }
            case 118: {
                return CANCELED;
            }
            case 119: {
                return NO_SUCH_OPERATION;
            }
            case 120: {
                return TOO_LATE;
            }
            case 121: {
                return CANNOT_CANCEL;
            }
            case 4096: {
                return E_SYNC_REFRESH_REQUIRED;
            }
        }
        return UNKNOWN;
    }

    public static ResultCodeEnum getBestEstimate(Throwable t, MessageTypeEnum type) {
        Set<ResultCodeEnum> candidates;
        Set<ResultCodeEnum> set = ResultCodeEnum.getResultCodes(t);
        if (set.isEmpty()) {
            return OTHER;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (type == null) {
            HashSet<ResultCodeEnum> tmp = new HashSet<ResultCodeEnum>();
            tmp.addAll(set);
            tmp.removeAll(NON_ERRONEOUS_CODES);
            if (tmp.isEmpty()) {
                return OTHER;
            }
            return (ResultCodeEnum)((Object)tmp.iterator().next());
        }
        switch (type) {
            case ABANDON_REQUEST: {
                return set.iterator().next();
            }
            case ADD_REQUEST: 
            case ADD_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, ADD_CODES);
                break;
            }
            case BIND_REQUEST: 
            case BIND_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, BIND_CODES);
                break;
            }
            case COMPARE_REQUEST: 
            case COMPARE_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, COMPARE_CODES);
                break;
            }
            case DEL_REQUEST: 
            case DEL_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, DELETE_CODES);
                break;
            }
            case EXTENDED_REQUEST: 
            case EXTENDED_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, EXTENDED_CODES);
                break;
            }
            case MODIFYDN_REQUEST: 
            case MODIFYDN_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, MODIFYDN_CODES);
                break;
            }
            case MODIFY_REQUEST: 
            case MODIFY_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, MODIFY_CODES);
                break;
            }
            case SEARCH_REQUEST: 
            case SEARCH_RESULT_DONE: 
            case SEARCH_RESULT_ENTRY: 
            case SEARCH_RESULT_REFERENCE: 
            case INTERMEDIATE_RESPONSE: {
                candidates = ResultCodeEnum.intersection(set, SEARCH_CODES);
                break;
            }
            case UNBIND_REQUEST: {
                return set.iterator().next();
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_13516_UNEXPECTED_MESSAGE_TYPE, (Object[])new Object[]{type}));
            }
        }
        candidates.removeAll(NON_ERRONEOUS_CODES);
        if (candidates.isEmpty()) {
            return OTHER;
        }
        return candidates.iterator().next();
    }

    private static Set<ResultCodeEnum> intersection(Set<ResultCodeEnum> s1, Set<ResultCodeEnum> s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return new HashSet<ResultCodeEnum>();
        }
        HashSet<ResultCodeEnum> intersection = new HashSet<ResultCodeEnum>();
        if (s1.size() <= s2.size()) {
            for (ResultCodeEnum item : s1) {
                if (!s2.contains((Object)item)) continue;
                intersection.add(item);
            }
        } else {
            for (ResultCodeEnum item : s2) {
                if (!s1.contains((Object)item)) continue;
                intersection.add(item);
            }
        }
        return intersection;
    }

    private static Set<ResultCodeEnum> getResultCodes(Throwable t) {
        ResultCodeEnum rc = ResultCodeEnum.getResultCode(t);
        if (rc != null) {
            return Collections.singleton(rc);
        }
        if (t instanceof LdapSchemaViolationException) {
            return SCHEMA_VIOLATION_EXCEPTION_CODES;
        }
        if (t instanceof LdapInvalidDnException) {
            return INVALID_NAME_EXCEPTION_CODES;
        }
        if (t instanceof LdapUnwillingToPerformException) {
            return OPERATION_NOT_SUPPORTED_EXCEPTION_CODES;
        }
        if (t instanceof LimitExceededException) {
            return LIMIT_EXCEEDED_EXCEPTION_CODES;
        }
        if (t instanceof PartialResultException) {
            return PARTIAL_RESULTS_EXCEPTION_CODES;
        }
        if (t instanceof LdapInvalidAttributeValueException) {
            return INVALID_ATTRIBUTE_VALUE_EXCEPTION_CODES;
        }
        if (t instanceof LdapServiceUnavailableException) {
            return SERVICE_UNAVAILABLE_CODES;
        }
        if (t instanceof LdapAuthenticationNotSupportedException) {
            return AUTHENTICATION_NOT_SUPPORTED_EXCEPTION_CODES;
        }
        if (t instanceof LdapException) {
            return NAMING_EXCEPTION_CODES;
        }
        return EMPTY_RESULT_CODE_SET;
    }

    public static ResultCodeEnum getResultCode(Throwable t) {
        if (t instanceof LdapOperationException) {
            return ((LdapOperationException)t).getResultCode();
        }
        if (t instanceof CommunicationException) {
            return PROTOCOL_ERROR;
        }
        if (t instanceof LdapTimeLimitExceededException) {
            return TIME_LIMIT_EXCEEDED;
        }
        if (t instanceof SizeLimitExceededException) {
            return SIZE_LIMIT_EXCEEDED;
        }
        if (t instanceof LdapAuthenticationException) {
            return INVALID_CREDENTIALS;
        }
        if (t instanceof LdapNoPermissionException) {
            return INSUFFICIENT_ACCESS_RIGHTS;
        }
        if (t instanceof LdapNoSuchAttributeException) {
            return NO_SUCH_ATTRIBUTE;
        }
        if (t instanceof LdapInvalidAttributeTypeException) {
            return UNDEFINED_ATTRIBUTE_TYPE;
        }
        if (t instanceof LdapInvalidSearchFilterException) {
            return INAPPROPRIATE_MATCHING;
        }
        if (t instanceof LdapAttributeInUseException) {
            return ATTRIBUTE_OR_VALUE_EXISTS;
        }
        if (t instanceof LdapNoSuchObjectException) {
            return NO_SUCH_OBJECT;
        }
        if (t instanceof LdapEntryAlreadyExistsException) {
            return ENTRY_ALREADY_EXISTS;
        }
        if (t instanceof LdapContextNotEmptyException) {
            return NOT_ALLOWED_ON_NON_LEAF;
        }
        return null;
    }

    public static boolean processResponse(ResultResponse response) throws LdapException {
        LdapResult ldapResult = response.getLdapResult();
        switch (ldapResult.getResultCode()) {
            case SUCCESS: 
            case PARTIAL_RESULTS: 
            case REFERRAL: 
            case SASL_BIND_IN_PROGRESS: 
            case CANCELED: 
            case COMPARE_TRUE: {
                return true;
            }
            case COMPARE_FALSE: {
                return false;
            }
            case INVALID_CREDENTIALS: {
                LdapAuthenticationException authenticationException = new LdapAuthenticationException(ldapResult.getDiagnosticMessage());
                authenticationException.setResolvedDn(ldapResult.getMatchedDn());
                throw authenticationException;
            }
            case UNWILLING_TO_PERFORM: 
            case UNAVAILABLE_CRITICAL_EXTENSION: {
                LdapUnwillingToPerformException unwillingToPerformException = new LdapUnwillingToPerformException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                unwillingToPerformException.setResolvedDn(ldapResult.getMatchedDn());
                throw unwillingToPerformException;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                LdapNoPermissionException ldapNoPermissionException = new LdapNoPermissionException(ldapResult.getDiagnosticMessage());
                ldapNoPermissionException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapNoPermissionException;
            }
            case NOT_ALLOWED_ON_NON_LEAF: {
                LdapContextNotEmptyException ldapContextNotEmptyException = new LdapContextNotEmptyException(ldapResult.getDiagnosticMessage());
                ldapContextNotEmptyException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapContextNotEmptyException;
            }
            case NO_SUCH_OBJECT: {
                LdapNoSuchObjectException ldapNoSuchObjectException = new LdapNoSuchObjectException(ldapResult.getDiagnosticMessage());
                ldapNoSuchObjectException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapNoSuchObjectException;
            }
            case NO_SUCH_ATTRIBUTE: {
                LdapNoSuchAttributeException ldapNoSuchAttributeException = new LdapNoSuchAttributeException(ldapResult.getDiagnosticMessage());
                ldapNoSuchAttributeException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapNoSuchAttributeException;
            }
            case ATTRIBUTE_OR_VALUE_EXISTS: {
                LdapAttributeInUseException ldapAttributeInUseException = new LdapAttributeInUseException(ldapResult.getDiagnosticMessage());
                ldapAttributeInUseException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAttributeInUseException;
            }
            case ENTRY_ALREADY_EXISTS: {
                LdapEntryAlreadyExistsException ldapEntryAlreadyExistsException = new LdapEntryAlreadyExistsException(ldapResult.getDiagnosticMessage());
                ldapEntryAlreadyExistsException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapEntryAlreadyExistsException;
            }
            case OBJECT_CLASS_VIOLATION: 
            case NOT_ALLOWED_ON_RDN: 
            case OBJECT_CLASS_MODS_PROHIBITED: {
                LdapSchemaViolationException ldapSchemaViolationException = new LdapSchemaViolationException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                ldapSchemaViolationException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapSchemaViolationException;
            }
            case ALIAS_PROBLEM: {
                LdapAliasException ldapAliasException = new LdapAliasException(ldapResult.getDiagnosticMessage());
                ldapAliasException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAliasException;
            }
            case AFFECTS_MULTIPLE_DSAS: {
                LdapAffectMultipleDsaException ldapAffectMultipleDsaException = new LdapAffectMultipleDsaException(ldapResult.getDiagnosticMessage());
                ldapAffectMultipleDsaException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAffectMultipleDsaException;
            }
            case ALIAS_DEREFERENCING_PROBLEM: {
                LdapAliasDereferencingException ldapAliasDereferencingException = new LdapAliasDereferencingException(ldapResult.getDiagnosticMessage());
                ldapAliasDereferencingException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAliasDereferencingException;
            }
            case AUTH_METHOD_NOT_SUPPORTED: 
            case INAPPROPRIATE_AUTHENTICATION: 
            case CONFIDENTIALITY_REQUIRED: {
                LdapAuthenticationNotSupportedException ldapAuthenticationNotSupportedException = new LdapAuthenticationNotSupportedException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                ldapAuthenticationNotSupportedException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAuthenticationNotSupportedException;
            }
            case BUSY: 
            case UNAVAILABLE: {
                LdapServiceUnavailableException ldapServiceUnavailableException = new LdapServiceUnavailableException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                ldapServiceUnavailableException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapServiceUnavailableException;
            }
            case CONSTRAINT_VIOLATION: 
            case INVALID_ATTRIBUTE_SYNTAX: {
                LdapInvalidAttributeValueException ldapInvalidAttributeValueException = new LdapInvalidAttributeValueException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                ldapInvalidAttributeValueException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapInvalidAttributeValueException;
            }
            case INAPPROPRIATE_MATCHING: {
                LdapInvalidSearchFilterException ldapInvalidSearchFilterException = new LdapInvalidSearchFilterException(ldapResult.getDiagnosticMessage());
                ldapInvalidSearchFilterException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapInvalidSearchFilterException;
            }
            case INVALID_DN_SYNTAX: 
            case NAMING_VIOLATION: {
                LdapInvalidDnException ldapInvalidDnException = new LdapInvalidDnException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
                ldapInvalidDnException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapInvalidDnException;
            }
            case LOOP_DETECT: {
                LdapLoopDetectedException ldapLoopDetectedException = new LdapLoopDetectedException(ldapResult.getDiagnosticMessage());
                ldapLoopDetectedException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapLoopDetectedException;
            }
            case OPERATIONS_ERROR: {
                LdapOperationErrorException ldapOperationErrorException = new LdapOperationErrorException(ldapResult.getDiagnosticMessage());
                ldapOperationErrorException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapOperationErrorException;
            }
            case PROTOCOL_ERROR: {
                LdapProtocolErrorException ldapProtocolErrorException = new LdapProtocolErrorException(ldapResult.getDiagnosticMessage());
                ldapProtocolErrorException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapProtocolErrorException;
            }
            case TIME_LIMIT_EXCEEDED: {
                LdapTimeLimitExceededException ldapTimeLimitExceededException = new LdapTimeLimitExceededException(ldapResult.getDiagnosticMessage());
                ldapTimeLimitExceededException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapTimeLimitExceededException;
            }
            case UNDEFINED_ATTRIBUTE_TYPE: {
                LdapInvalidAttributeTypeException ldapInvalidAttributeTypeException = new LdapInvalidAttributeTypeException(ldapResult.getDiagnosticMessage());
                ldapInvalidAttributeTypeException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapInvalidAttributeTypeException;
            }
            case OTHER: {
                LdapOtherException ldapOtherException = new LdapOtherException(ldapResult.getDiagnosticMessage());
                ldapOtherException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapOtherException;
            }
            case SIZE_LIMIT_EXCEEDED: {
                LdapSizeLimitExceededException ldapSizeLimitExceededException = new LdapSizeLimitExceededException(ldapResult.getDiagnosticMessage());
                ldapSizeLimitExceededException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapSizeLimitExceededException;
            }
            case STRONG_AUTH_REQUIRED: {
                LdapStrongAuthenticationRequiredException ldapStrongAuthenticationRequiredException = new LdapStrongAuthenticationRequiredException(ldapResult.getDiagnosticMessage());
                ldapStrongAuthenticationRequiredException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapStrongAuthenticationRequiredException;
            }
            case ADMIN_LIMIT_EXCEEDED: {
                LdapAdminLimitExceededException ldapAdminLimitExceededException = new LdapAdminLimitExceededException(ldapResult.getDiagnosticMessage());
                ldapAdminLimitExceededException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapAdminLimitExceededException;
            }
            case TOO_LATE: {
                LdapTooLateException ldapTooLateException = new LdapTooLateException(ldapResult.getDiagnosticMessage());
                ldapTooLateException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapTooLateException;
            }
            case UNKNOWN: {
                LdapUnknownException ldapUnknownException = new LdapUnknownException(ldapResult.getDiagnosticMessage());
                ldapUnknownException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapUnknownException;
            }
            case CANNOT_CANCEL: {
                LdapCannotCancelException ldapCannotCancelException = new LdapCannotCancelException(ldapResult.getDiagnosticMessage());
                ldapCannotCancelException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapCannotCancelException;
            }
            case NO_SUCH_OPERATION: {
                LdapNoSuchOperationException ldapNoSuchOperationException = new LdapNoSuchOperationException(ldapResult.getDiagnosticMessage());
                ldapNoSuchOperationException.setResolvedDn(ldapResult.getMatchedDn());
                throw ldapNoSuchOperationException;
            }
        }
        LdapOperationException exception = new LdapOperationException(ldapResult.getResultCode(), ldapResult.getDiagnosticMessage());
        exception.setResolvedDn(ldapResult.getMatchedDn());
        throw exception;
    }

    static {
        EMPTY_RESULT_CODE_SET = new HashSet<ResultCodeEnum>();
        HashSet<ResultCodeEnum> set = new HashSet<ResultCodeEnum>();
        set.add(SUCCESS);
        set.add(COMPARE_TRUE);
        set.add(COMPARE_FALSE);
        set.add(REFERRAL);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(CANCELED);
        NON_ERRONEOUS_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(INVALID_CREDENTIALS);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        BIND_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        set.add(E_SYNC_REFRESH_REQUIRED);
        SEARCH_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        MODIFY_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(NAMING_VIOLATION);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        ADD_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        DELETE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(OTHER);
        set.add(SUCCESS);
        set.add(REFERRAL);
        set.add(LOOP_DETECT);
        set.add(UNAVAILABLE);
        set.add(NO_SUCH_OBJECT);
        set.add(PROTOCOL_ERROR);
        set.add(INVALID_DN_SYNTAX);
        set.add(NAMING_VIOLATION);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(UNWILLING_TO_PERFORM);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(CONSTRAINT_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CANCELED);
        MODIFYDN_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONS_ERROR);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(COMPARE_FALSE);
        set.add(COMPARE_TRUE);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(NO_SUCH_OBJECT);
        set.add(INVALID_DN_SYNTAX);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLING_TO_PERFORM);
        set.add(LOOP_DETECT);
        set.add(REFERRAL);
        set.add(OTHER);
        set.add(CANCELED);
        COMPARE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(SUCCESS);
        set.add(OPERATIONS_ERROR);
        set.add(PROTOCOL_ERROR);
        set.add(TIME_LIMIT_EXCEEDED);
        set.add(SIZE_LIMIT_EXCEEDED);
        set.add(COMPARE_FALSE);
        set.add(COMPARE_TRUE);
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(REFERRAL);
        set.add(ADMIN_LIMIT_EXCEEDED);
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(SASL_BIND_IN_PROGRESS);
        set.add(NO_SUCH_ATTRIBUTE);
        set.add(UNDEFINED_ATTRIBUTE_TYPE);
        set.add(INAPPROPRIATE_MATCHING);
        set.add(CONSTRAINT_VIOLATION);
        set.add(ATTRIBUTE_OR_VALUE_EXISTS);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        set.add(NO_SUCH_OBJECT);
        set.add(ALIAS_PROBLEM);
        set.add(INVALID_DN_SYNTAX);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        set.add(INVALID_CREDENTIALS);
        set.add(INSUFFICIENT_ACCESS_RIGHTS);
        set.add(BUSY);
        set.add(UNAVAILABLE);
        set.add(UNWILLING_TO_PERFORM);
        set.add(LOOP_DETECT);
        set.add(NAMING_VIOLATION);
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_NON_LEAF);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(ENTRY_ALREADY_EXISTS);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(OTHER);
        set.add(CANCELED);
        EXTENDED_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OPERATIONS_ERROR);
        set.add(ALIAS_PROBLEM);
        set.add(ALIAS_DEREFERENCING_PROBLEM);
        set.add(LOOP_DETECT);
        set.add(AFFECTS_MULTIPLE_DSAS);
        set.add(OTHER);
        NAMING_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(AUTH_METHOD_NOT_SUPPORTED);
        set.add(STRONG_AUTH_REQUIRED);
        set.add(CONFIDENTIALITY_REQUIRED);
        set.add(INAPPROPRIATE_AUTHENTICATION);
        AUTHENTICATION_NOT_SUPPORTED_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(BUSY);
        set.add(UNAVAILABLE);
        SERVICE_UNAVAILABLE_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(CONSTRAINT_VIOLATION);
        set.add(INVALID_ATTRIBUTE_SYNTAX);
        INVALID_ATTRIBUTE_VALUE_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(PARTIAL_RESULTS);
        set.add(REFERRAL);
        PARTIAL_RESULTS_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(REFERRAL);
        set.add(ADMIN_LIMIT_EXCEEDED);
        LIMIT_EXCEEDED_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(UNAVAILABLE_CRITICAL_EXTENSION);
        set.add(UNWILLING_TO_PERFORM);
        OPERATION_NOT_SUPPORTED_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(INVALID_DN_SYNTAX);
        set.add(NAMING_VIOLATION);
        INVALID_NAME_EXCEPTION_CODES = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(OBJECT_CLASS_VIOLATION);
        set.add(NOT_ALLOWED_ON_RDN);
        set.add(OBJECT_CLASS_MODS_PROHIBITED);
        SCHEMA_VIOLATION_EXCEPTION_CODES = Collections.unmodifiableSet(set);
    }
}

