/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.control;

import com.googlecode.wicket.jquery.ui.form.button.IndicatingAjaxButton;
import org.apache.directory.fortress.core.AccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.control.SecureIndicatingAjaxButton;
import org.apache.directory.fortress.web.control.WicketSession;
import org.apache.wicket.Component;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtIndicatingAjaxButton
extends IndicatingAjaxButton {
    Permission perm;
    @SpringBean
    private AccessMgr accessMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)SecureIndicatingAjaxButton.class.getName());

    public FtIndicatingAjaxButton(String id) {
        super(id);
        String[] parts = id.split("\\.");
        if (parts.length > 1) {
            String objName = parts[0];
            String opName = parts[1];
            this.perm = new Permission(objName, opName);
            if (SecUtils.isFound((Permission)this.perm, (Component)this)) {
                LOG.debug("FtIndicatingAjaxButton id: " + id + ", status found");
            } else {
                LOG.debug("FtIndicatingAjaxButton id: " + id + ", status NOT found");
                this.setVisible(false);
            }
        } else {
            throw new RuntimeException("FtIndicatingAjaxButton Constructor ID: " + id + ", requires objectname.opname format");
        }
    }

    protected boolean checkAccess() {
        boolean isAuthorized = false;
        try {
            WicketSession session = (WicketSession)this.getSession();
            isAuthorized = this.accessMgr.checkAccess(session.getSession(), this.perm);
            LOG.info("Fortress checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + " userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
        }
        catch (SecurityException se) {
            String error = "Fortress SecurityException checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + " error=" + se;
            LOG.error(error);
        }
        return isAuthorized;
    }

    protected boolean checkAccess(String objectId) {
        boolean isAuthorized = false;
        try {
            WicketSession session = (WicketSession)this.getSession();
            Permission finePerm = new Permission(this.perm.getObjName(), this.perm.getOpName(), objectId);
            isAuthorized = this.accessMgr.checkAccess(session.getSession(), finePerm);
            LOG.info("Fortress checkAccess objName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + ", objId: " + finePerm.getObjId() + ", userId: " + session.getSession().getUserId() + " result: " + isAuthorized);
        }
        catch (SecurityException se) {
            String error = "Fortress SecurityException checkAccess objectName: " + this.perm.getObjName() + " opName: " + this.perm.getOpName() + ", objId: " + objectId + ", error=" + se;
            LOG.error(error);
        }
        return isAuthorized;
    }
}

