/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwPolicyListModel
extends Model<SerializableList<PwPolicy>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private PwPolicyMgr pwPolicyMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)PwPolicyListModel.class.getName());
    private PwPolicy policy;
    private SerializableList<PwPolicy> policies = null;

    public PwPolicyListModel(Session session) {
        Injector.get().inject((Object)this);
    }

    public PwPolicyListModel(PwPolicy policy, Session session) {
        Injector.get().inject((Object)this);
        this.policy = policy;
    }

    public SerializableList<PwPolicy> getObject() {
        if (this.policies != null) {
            LOG.debug(".getObject count: " + this.policies.size());
            return this.policies;
        }
        if (this.policy == null) {
            LOG.debug(".getObject null");
            this.policies = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject policyNm: " + this.policy.getName());
            this.policies = new SerializableList(this.getList(this.policy));
        }
        return this.policies;
    }

    public void setObject(SerializableList<PwPolicy> object) {
        LOG.debug(".setObject count: " + object.size());
        this.policies = object;
    }

    public void detach() {
        this.policies = null;
        this.policy = null;
    }

    private List<PwPolicy> getList(PwPolicy policy) {
        List policiesList = null;
        try {
            String szPolicyNm = policy != null ? policy.getName() : "";
            LOG.debug(".getList policyNm: " + szPolicyNm);
            policiesList = this.pwPolicyMgr.search(szPolicyNm);
            if (CollectionUtils.isNotEmpty((Collection)policiesList)) {
                Collections.sort(policiesList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return policiesList;
    }
}

