/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.googlecode.wicket.kendo.ui.form.datetime.DatePicker;
import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.time.TUtil;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.AuditModListModel;
import org.apache.directory.fortress.web.panel.AuditModListPanel;
import org.apache.directory.fortress.web.panel.PermSearchModalPanel;
import org.apache.directory.fortress.web.panel.UserSearchModalPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditModListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditModListPanel.class.getName());
    private Form listForm;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private TextField userFld;
    private TextField objFld;
    private TextField opFld;
    protected DatePicker beginDateDP;
    protected DatePicker endDateDP;
    private Permission permission;

    public AuditModListPanel(String id, UserAudit userAudit) {
        super(id);
        this.init(userAudit);
    }

    private void init(UserAudit userAudit) {
        AuditModListModel pageModel = new AuditModListModel(userAudit, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)pageModel);
        this.createAndLoadGrid();
        this.listForm = new Form("modform");
        this.listForm.addOrReplace(new Component[]{this.grid});
        this.listForm.setModel((IModel)new CompoundPropertyModel((Object)userAudit));
        this.addFormFields();
        this.addButtons();
        this.add(new Component[]{this.listForm});
    }

    private void addFormFields() {
        this.userFld = new TextField("userId");
        this.userFld.setOutputMarkupId(true);
        1 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.userFld.add(new Behavior[]{ajaxUpdater});
        this.listForm.add(new Component[]{this.userFld});
        this.addUserSearchModal();
        this.objFld = new TextField("objName");
        this.objFld.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.objFld.add(new Behavior[]{ajaxUpdater});
        this.listForm.add(new Component[]{this.objFld});
        this.opFld = new TextField("opName");
        this.opFld.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.opFld.add(new Behavior[]{ajaxUpdater});
        this.listForm.add(new Component[]{this.opFld});
        this.addPermSearchModal();
        this.beginDateDP = new DatePicker("beginDate");
        this.beginDateDP.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.beginDateDP.add(new Behavior[]{ajaxUpdater});
        this.beginDateDP.setRequired(false);
        this.listForm.add(new Component[]{this.beginDateDP});
        this.endDateDP = new DatePicker("endDate");
        this.endDateDP.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.endDateDP.add(new Behavior[]{ajaxUpdater});
        this.endDateDP.setRequired(false);
        this.listForm.add(new Component[]{this.endDateDP});
    }

    private void addButtons() {
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void createAndLoadGrid() {
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn reqStart = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Timestamp")), "userObject.reqStart");
        reqStart.setInitialSize(200);
        columns.add(reqStart);
        PropertyColumn reqAttr = new PropertyColumn((IModel)Model.of((Serializable)((Object)"LDAP Operation")), "userObject.reqType");
        reqAttr.setInitialSize(150);
        columns.add(reqAttr);
        PropertyColumn reqAttrsOnly = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Target Location")), "userObject.reqDN");
        reqAttrsOnly.setInitialSize(500);
        columns.add(reqAttrsOnly);
        List mods = (List)this.getDefaultModel().getObject();
        DefaultTreeModel treeModel = this.createTreeModel(mods);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.grid.setOutputMarkupId(true);
    }

    private void addUserSearchModal() {
        Component[] componentArray = new Component[1];
        ModalWindow usersModalWindow = new ModalWindow("usersearchmodal");
        componentArray[0] = usersModalWindow;
        this.listForm.add(componentArray);
        UserSearchModalPanel userSearchModalPanel = new UserSearchModalPanel(usersModalWindow.getContentId(), usersModalWindow);
        usersModalWindow.setContent((Component)userSearchModalPanel);
        usersModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        usersModalWindow.setTitle("User Search Modal");
        usersModalWindow.setInitialWidth(1000);
        usersModalWindow.setInitialHeight(700);
        usersModalWindow.setCookieName("user-search-modal");
    }

    private void addPermSearchModal() {
        Component[] componentArray = new Component[1];
        ModalWindow permsModalWindow = new ModalWindow("permsearchmodal");
        componentArray[0] = permsModalWindow;
        this.listForm.add(componentArray);
        PermSearchModalPanel permSearchModalPanel = new PermSearchModalPanel(permsModalWindow.getContentId(), permsModalWindow, true);
        permsModalWindow.setContent((Component)permSearchModalPanel);
        permsModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        permsModalWindow.setTitle("Admin Permission Search Modal");
        permsModalWindow.setInitialWidth(650);
        permsModalWindow.setInitialHeight(450);
        permsModalWindow.setCookieName("perm-search-modal");
    }

    private DefaultTreeModel createTreeModel(List<Mod> mods) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (mods == null) {
            LOG.debug("no Modifications found");
        } else {
            LOG.debug("AuthZ found:" + mods.size());
            this.info((Serializable)((Object)("Loading " + mods.size() + " objects into list panel")));
            this.loadTree(mods);
        }
        return model;
    }

    private void loadTree(List<Mod> mods) {
        for (Mod mod : mods) {
            Date start = null;
            try {
                start = TUtil.decodeGeneralizedTime((String)mod.getReqStart());
            }
            catch (ParseException pe) {
                LOG.warn("ParseException=" + pe.getMessage());
            }
            if (start != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                String formattedDate = formatter.format(start);
                mod.setReqStart(formattedDate);
            }
            this.rootNode.add(new DefaultMutableTreeNode(mod));
        }
    }
}

