/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.model.RoleListModel;
import org.apache.directory.fortress.web.panel.RoleListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleListPanel<T extends Serializable>
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)RoleListPanel.class.getName());
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String searchVal;
    private boolean isAdmin;

    public RoleListPanel(String id, boolean isAdmin) {
        super(id);
        this.isAdmin = isAdmin;
        RoleListModel roleListModel = new RoleListModel(this.createRole(""), isAdmin, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)roleListModel);
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Name")), "userObject.name"));
        PropertyColumn description = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(300);
        columns.add(description);
        PropertyColumn beginDate = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Begin Date")), "userObject.BeginDate");
        beginDate.setInitialSize(80);
        columns.add(beginDate);
        PropertyColumn endDate = new PropertyColumn((IModel)Model.of((Serializable)((Object)"End Date")), "userObject.EndDate");
        endDate.setInitialSize(80);
        columns.add(endDate);
        PropertyColumn beginLockDate = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Begin Lock Dt")), "userObject.BeginLockDate");
        beginLockDate.setInitialSize(80);
        columns.add(beginLockDate);
        PropertyColumn endLockDate = new PropertyColumn((IModel)Model.of((Serializable)((Object)"End Lock Dt")), "userObject.EndLockDate");
        endLockDate.setInitialSize(80);
        columns.add(endLockDate);
        PropertyColumn beginTime = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Begin Tm")), "userObject.BeginTime");
        beginTime.setInitialSize(70);
        columns.add(beginTime);
        PropertyColumn endTime = new PropertyColumn((IModel)Model.of((Serializable)((Object)"End Tm")), "userObject.EndTime");
        endTime.setInitialSize(70);
        columns.add(endTime);
        PropertyColumn dayMask = new PropertyColumn((IModel)Model.of((Serializable)((Object)"DayMask")), "userObject.DayMask");
        dayMask.setInitialSize(80);
        columns.add(dayMask);
        PropertyColumn parents = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Parents")), "userObject.parents");
        parents.setInitialSize(250);
        columns.add(parents);
        List roles = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(roles);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        Form listForm = new Form("form");
        listForm.add(new Component[]{this.grid});
        this.grid.setOutputMarkupId(true);
        TextField searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        listForm.add(new Component[]{searchValFld});
        listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{listForm});
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (3.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent SaveModelEvent: " + target.toString());
        }
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List roles = (List)this.getDefaultModelObject();
            roles.add((Role)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, roles.size());
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            Role role = (Role)node.getUserObject();
            LOG.debug(".removeSelectedItems role node: " + role.getName());
            List roles = (List)this.getDefaultModel().getObject();
            roles.remove(role);
        }
    }

    private DefaultTreeModel createTreeModel(List<T> roles) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (roles == null) {
            LOG.debug("no Roles found");
        } else {
            LOG.debug("Roles found:" + roles.size());
            for (Serializable role : roles) {
                this.rootNode.add(new DefaultMutableTreeNode(role));
            }
        }
        return model;
    }

    private Role createRole(String name) {
        Object role = this.isAdmin ? new AdminRole(name) : new Role(name);
        return role;
    }
}

