/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DelegateEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;

public class ContinuedSearchResultEntry
extends DelegateEntry
implements IContinuation {
    private static final long serialVersionUID = -6351277968774226912L;
    private LdapUrl url;
    private IContinuation.State state;
    private DummyConnection dummyConnection;

    protected ContinuedSearchResultEntry() {
    }

    public ContinuedSearchResultEntry(IBrowserConnection connection, Dn dn) {
        super(connection, dn);
        this.state = IContinuation.State.RESOLVED;
    }

    public void setUnresolved(LdapUrl url) {
        this.state = IContinuation.State.UNRESOLVED;
        this.url = url;
        this.connectionId = null;
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        if (this.state == IContinuation.State.RESOLVED) {
            return super.getBrowserConnection();
        }
        if (this.dummyConnection == null) {
            this.dummyConnection = new DummyConnection(Schema.DEFAULT_SCHEMA);
        }
        return this.dummyConnection;
    }

    @Override
    protected IEntry getDelegate() {
        if (this.state == IContinuation.State.RESOLVED) {
            return super.getDelegate();
        }
        return null;
    }

    @Override
    public IContinuation.State getState() {
        return this.state;
    }

    @Override
    public LdapUrl getUrl() {
        return this.url != null ? this.url : super.getUrl();
    }

    @Override
    public void resolve() {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.url.toString());
        Connection referralConnection = ConnectionCorePlugin.getDefault().getReferralHandler().getReferralConnection(urls);
        if (referralConnection == null) {
            this.state = IContinuation.State.CANCELED;
            this.entryDoesNotExist = true;
        } else {
            this.state = IContinuation.State.RESOLVED;
            this.connectionId = referralConnection.getId();
            InitializeAttributesRunnable iar = new InitializeAttributesRunnable(this);
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{iar}).execute();
        }
    }

    public int hashCode() {
        return this.getDn().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContinuedSearchResultEntry)) {
            return false;
        }
        ContinuedSearchResultEntry e = (ContinuedSearchResultEntry)o;
        return this.getDn() == null ? e.getDn() == null : this.getDn().equals((Object)e.getDn()) && this.getBrowserConnection().equals(e.getBrowserConnection());
    }
}

