/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.externals.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.util.Collection;
import org.apache.flex.compiler.clients.ExternCConfiguration;
import org.apache.flex.compiler.internal.codegen.externals.pass.ReferenceCompiler;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;
import org.apache.flex.compiler.internal.codegen.externals.utils.DebugLogUtils;

public abstract class AbstractCompilerPass
implements CompilerPass,
NodeTraversal.Callback {
    protected ReferenceModel model;
    protected AbstractCompiler compiler;
    protected boolean logEnabled;
    protected boolean errEnabled;

    public AbstractCompilerPass(ReferenceModel model, AbstractCompiler compiler) {
        this.model = model;
        this.compiler = compiler;
    }

    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots((AbstractCompiler)this.compiler, (NodeTraversal.Callback)this, (Node)externs, (Node)root);
    }

    protected void log(Node n) {
        DebugLogUtils.err(n);
    }

    protected void err(Node n) {
        DebugLogUtils.err(n);
    }

    protected void log(String message) {
        DebugLogUtils.log(message);
    }

    protected void err(String message) {
        DebugLogUtils.err(message);
    }

    protected String getSourceCode(StaticSourceFile file, int line) {
        if (file instanceof SourceFile) {
            String code = ((SourceFile)file).getLine(line);
            return code;
        }
        return "no source line found";
    }

    public static String getSourceFileName(String externName, ReferenceModel model) {
        if (externName.contains("[")) {
            externName = externName.replace("[", "");
            externName = externName.replace("]", "");
            ExternCConfiguration config = model.getConfiguration();
            Collection<ReferenceCompiler.ExternalFile> externs = config.getExternals();
            for (ReferenceCompiler.ExternalFile f : externs) {
                String fn = f.getName();
                if (!fn.equals(externName)) continue;
                externName = f.getFile().getAbsolutePath();
                break;
            }
        }
        return externName;
    }
}

