/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.externals.pass;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.apache.flex.compiler.internal.codegen.externals.pass.AbstractCompilerPass;
import org.apache.flex.compiler.internal.codegen.externals.reference.ClassReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.FieldReference;
import org.apache.flex.compiler.internal.codegen.externals.reference.ReferenceModel;

public class ResolvePackagesPass
extends AbstractCompilerPass {
    public ResolvePackagesPass(ReferenceModel model, AbstractCompiler compiler) {
        super(model, compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        this.log(">>>-----------------------------");
        for (ClassReference reference : this.model.getClasses()) {
            if (reference.isQualifiedName()) {
                reference.setIsNamespace(true);
            }
            this.log(reference.getQualifiedName());
            List<ClassReference> list = this.getFirstChildren(reference);
        }
        this.log("<<<-----------------------------");
    }

    private List<ClassReference> getFirstChildren(ClassReference reference) {
        ArrayList<ClassReference> result = new ArrayList<ClassReference>();
        String qualifiedName = reference.getQualifiedName();
        String[] split = qualifiedName.split("\\.");
        for (ClassReference child : this.model.getClasses()) {
            FieldReference field;
            String baseName = child.getBaseName();
            String testName = qualifiedName + "." + baseName;
            if (!testName.equals(child.getQualifiedName())) continue;
            if (!reference.isQualifiedName()) {
                this.log("   Add field: public static var " + baseName);
                field = reference.addField(child.getNode(), baseName, child.getNode().getJSDocInfo(), true);
            } else {
                this.log("   Add field: public var " + baseName);
                field = reference.addField(child.getNode(), baseName, child.getNode().getJSDocInfo(), false);
            }
            field.setOverrideStringType(child.getQualifiedName());
        }
        return result;
    }

    public boolean shouldTraverse(NodeTraversal arg0, Node arg1, Node arg2) {
        return false;
    }

    public void visit(NodeTraversal arg0, Node arg1, Node arg2) {
    }
}

