/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.collect.Range;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;

public abstract class ComparableSubject<S extends Subject<S, T>, T extends Comparable>
extends Subject<S, T> {
    ComparableSubject(FailureStrategy failureStrategy, T subject) {
        super(failureStrategy, subject);
    }

    public final void isIn(Range<T> range) {
        if (!range.contains((Comparable)this.getSubject())) {
            this.fail("is in", (Object)range);
        }
    }

    public final void isNotIn(Range<T> range) {
        if (range.contains((Comparable)this.getSubject())) {
            this.fail("is not in", (Object)range);
        }
    }

    public final void comparesEqualTo(T other) {
        if (((Comparable)this.getSubject()).compareTo(other) != 0) {
            this.failWithRawMessage("%s should have been equivalent to <%s>", this.getDisplaySubject(), other);
        }
    }

    public final void isGreaterThan(T other) {
        if (((Comparable)this.getSubject()).compareTo(other) <= 0) {
            this.fail("is greater than", (Object)other);
        }
    }

    public final void isLessThan(T other) {
        if (((Comparable)this.getSubject()).compareTo(other) >= 0) {
            this.fail("is less than", (Object)other);
        }
    }

    public final void isAtMost(T other) {
        if (((Comparable)this.getSubject()).compareTo(other) > 0) {
            this.fail("is at most", (Object)other);
        }
    }

    public final void isAtLeast(T other) {
        if (((Comparable)this.getSubject()).compareTo(other) < 0) {
            this.fail("is at least", (Object)other);
        }
    }
}

