/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.ListSubject;
import com.google.common.truth.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrimitiveDoubleArraySubject
extends AbstractArraySubject<PrimitiveDoubleArraySubject, double[]> {
    PrimitiveDoubleArraySubject(FailureStrategy failureStrategy, double[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "double";
    }

    @Override
    protected List<Double> listRepresentation() {
        return Doubles.asList((double[])((double[])this.getSubject()));
    }

    @Override
    @Deprecated
    public void isEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of doubles is unsafe, use isEqualTo(double[] array, double tolerance) instead.");
    }

    public void isEqualTo(Object expected, double tolerance) {
        double[] actual = (double[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            double[] expectedArray = (double[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Arrays.asList(new double[][]{expectedArray}), Arrays.asList(new double[][]{actual}));
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equals(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Doubles.asList((double[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    @Deprecated
    public void isNotEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of floats is unsafe, use isNotEqualTo(double[] array, float tolerance) instead.");
    }

    public void isNotEqualTo(Object expectedArray, double tolerance) {
        double[] actual = (double[])this.getSubject();
        try {
            double[] expected = (double[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equals(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Doubles.asList((double[])expected));
            }
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
    }

    private ListSubject<?, Double, List<Double>> asList() {
        return ListSubject.create(this.failureStrategy, this.listRepresentation());
    }
}

