/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.ActionDecoder;
import flash.swf.DebugDecoder;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.TagValues;
import flash.swf.debug.DebugTable;
import flash.swf.tags.CSMTextSettings;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineBinaryData;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsJPEG3;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineButtonCxform;
import flash.swf.tags.DefineButtonSound;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFont1;
import flash.swf.tags.DefineFont2;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineFont4;
import flash.swf.tags.DefineFontAlignZones;
import flash.swf.tags.DefineFontInfo;
import flash.swf.tags.DefineFontName;
import flash.swf.tags.DefineMorphShape;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineSceneAndFrameLabelData;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DefineVideoStream;
import flash.swf.tags.DoABC;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.EnableTelemetry;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.FrameLabel;
import flash.swf.tags.GenericTag;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.Metadata;
import flash.swf.tags.PlaceObject;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.RemoveObject;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.tags.SetTabIndex;
import flash.swf.tags.ShowFrame;
import flash.swf.tags.SoundStreamHead;
import flash.swf.tags.StartSound;
import flash.swf.tags.SymbolClass;
import flash.swf.tags.VideoFrame;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.BevelFilter;
import flash.swf.types.BlurFilter;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.ButtonRecord;
import flash.swf.types.CXForm;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.ColorMatrixFilter;
import flash.swf.types.ConvolutionFilter;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.DropShadowFilter;
import flash.swf.types.FillStyle;
import flash.swf.types.Filter;
import flash.swf.types.FlashUUID;
import flash.swf.types.FocalGradient;
import flash.swf.types.GlowFilter;
import flash.swf.types.GlyphEntry;
import flash.swf.types.GradRecord;
import flash.swf.types.Gradient;
import flash.swf.types.GradientBevelFilter;
import flash.swf.types.GradientGlowFilter;
import flash.swf.types.ImportRecord;
import flash.swf.types.KerningRecord;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.MorphFillStyle;
import flash.swf.types.MorphGradRecord;
import flash.swf.types.MorphLineStyle;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.SoundInfo;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.swf.types.TextRecord;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.InflaterInputStream;

public final class TagDecoder
implements TagValues {
    private Header header;
    private InputStream swfIn;
    private InputStream swdIn;
    private URL swfUrl;
    private DebugTable swd;
    private SwfDecoder r;
    private GenericTag jpegTables;
    private TagHandler handler;
    private boolean keepOffsets;
    private Dictionary dict = new Dictionary();

    public TagDecoder(InputStream inputStream) {
        this.swfIn = inputStream;
        this.swdIn = null;
    }

    public TagDecoder(InputStream inputStream, InputStream inputStream2) {
        this.swfIn = inputStream;
        this.swdIn = inputStream2;
    }

    public TagDecoder(InputStream inputStream, URL uRL) {
        this.swfIn = inputStream;
        this.swfUrl = uRL;
    }

    public void setKeepOffsets(boolean bl) {
        this.keepOffsets = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(TagHandler tagHandler) throws IOException {
        this.handler = tagHandler;
        try {
            try {
                tagHandler.setDecoderDictionary(this.dict);
                this.header = this.decodeHeader();
                tagHandler.header(this.header);
                this.decodeTags(tagHandler);
                tagHandler.finish();
                if (this.swfIn == null) return;
            }
            catch (FatalParseException fatalParseException) {
                if (this.swfIn == null) return;
                this.swfIn.close();
                return;
            }
            catch (Throwable throwable) {
                if (this.swfIn == null) throw throwable;
                this.swfIn.close();
                throw throwable;
            }
            this.swfIn.close();
            return;
        }
        finally {
            if (this.swdIn != null) {
                this.swdIn.close();
            }
        }
    }

    public int getSwfVersion() {
        return this.header.version;
    }

    private void decodeTags(TagHandler tagHandler) throws IOException {
        int n;
        do {
            int n2 = this.r.getOffset();
            int n3 = this.r.readUI16();
            n = n3 >> 6;
            int n4 = n3 & 0x3F;
            if (n4 == 63 && (n4 = this.r.readSI32()) < 0) {
                tagHandler.error("negative tag length: " + n4 + " at offset " + n2);
                break;
            }
            int n5 = this.r.getOffset();
            int n6 = 0;
            if (n == 0) continue;
            Tag tag = this.decodeTag(n, n4);
            if (this.r.getOffset() - n5 != n4) {
                tagHandler.error("offset mismatch after " + Tag.names[tag.code] + ": read " + (this.r.getOffset() - n5) + ", expected " + n4);
                if (this.r.getOffset() - n5 < n4) {
                    n6 = n4 - (this.r.getOffset() - n5);
                }
            }
            tagHandler.setOffsetAndSize(n2, this.r.getOffset() - n2);
            tagHandler.any(tag);
            tag.visit(tagHandler);
            if (n6 <= 0) continue;
            this.r.read(new byte[n6]);
        } while (n != 0);
    }

    private Tag decodeTag(int n, int n2) throws IOException {
        Tag tag;
        int n3 = this.r.getOffset();
        switch (n) {
            case 41: {
                tag = this.decodeSerialNumber();
                break;
            }
            case 1: {
                tag = new ShowFrame();
                break;
            }
            case 77: {
                tag = this.decodeMetadata();
                break;
            }
            case 2: 
            case 22: 
            case 32: 
            case 83: {
                tag = this.decodeDefineShape(n);
                break;
            }
            case 4: {
                tag = this.decodePlaceObject(n2);
                break;
            }
            case 5: 
            case 28: {
                tag = this.decodeRemoveObject(n);
                break;
            }
            case 87: {
                tag = this.decodeDefineBinaryData(n2);
                break;
            }
            case 6: {
                tag = this.decodeDefineBits(n2);
                break;
            }
            case 7: {
                tag = this.decodeDefineButton(n2);
                break;
            }
            case 8: {
                this.jpegTables = this.decodeJPEGTables(n2);
                tag = this.jpegTables;
                break;
            }
            case 9: {
                tag = this.decodeSetBackgroundColor();
                break;
            }
            case 10: {
                tag = this.decodeDefineFont();
                break;
            }
            case 11: 
            case 33: {
                tag = this.decodeDefineText(n);
                break;
            }
            case 12: {
                tag = this.decodeDoAction(n2);
                break;
            }
            case 13: 
            case 62: {
                tag = this.decodeDefineFontInfo(n, n2);
                break;
            }
            case 14: {
                tag = this.decodeDefineSound(n2);
                break;
            }
            case 15: {
                tag = this.decodeStartSound();
                break;
            }
            case 17: {
                tag = this.decodeDefineButtonSound();
                break;
            }
            case 18: 
            case 45: {
                tag = this.decodeSoundStreamHead(n);
                break;
            }
            case 19: {
                tag = this.decodeSoundStreamBlock(n2);
                break;
            }
            case 20: {
                tag = this.decodeDefineBitsLossless(n2);
                break;
            }
            case 21: {
                tag = this.decodeDefineJPEG2(n2);
                break;
            }
            case 23: {
                tag = this.decodeDefineButtonCxform();
                break;
            }
            case 24: {
                tag = this.decodeProtect(n2);
                break;
            }
            case 26: {
                tag = this.decodePlaceObject23(26, n2);
                break;
            }
            case 70: {
                tag = this.decodePlaceObject23(70, n2);
                break;
            }
            case 34: {
                tag = this.decodeDefineButton2(n2);
                break;
            }
            case 35: {
                tag = this.decodeDefineJPEG3(n2);
                break;
            }
            case 36: {
                tag = this.decodeDefineBitsLossless2(n2);
                break;
            }
            case 37: {
                tag = this.decodeDefineEditText();
                break;
            }
            case 39: {
                tag = this.decodeDefineSprite(n3 + n2);
                break;
            }
            case 78: {
                tag = this.decodeDefineScalingGrid();
                break;
            }
            case 43: {
                tag = this.decodeFrameLabel(n2);
                break;
            }
            case 46: {
                tag = this.decodeDefineMorphShape();
                break;
            }
            case 84: {
                tag = this.decodeDefineMorphShape2();
                break;
            }
            case 48: {
                tag = this.decodeDefineFont2();
                break;
            }
            case 75: {
                tag = this.decodeDefineFont3();
                break;
            }
            case 91: {
                tag = this.decodeDefineFont4(n2);
                break;
            }
            case 56: {
                tag = this.decodeExportAssets();
                break;
            }
            case 57: 
            case 71: {
                tag = this.decodeImportAssets(n);
                break;
            }
            case 58: 
            case 64: {
                tag = this.decodeEnableDebugger(n);
                break;
            }
            case 59: {
                tag = this.decodeDoInitAction(n2);
                break;
            }
            case 60: {
                tag = this.decodeDefineVideoStream();
                break;
            }
            case 61: {
                tag = this.decodeVideoFrame(n2);
                break;
            }
            case 63: {
                tag = this.decodeDebugID(n, n2);
                break;
            }
            case 65: {
                tag = this.decodeScriptLimits();
                break;
            }
            case 66: {
                tag = this.decodeSetTabIndex();
                break;
            }
            case 72: 
            case 82: {
                tag = this.decodeDoABC(n, n2);
                break;
            }
            case 76: {
                tag = this.decodeSymbolClass();
                break;
            }
            case 69: {
                tag = this.decodeFileAttributes();
                break;
            }
            case 93: {
                tag = this.decodeEnableTelemetry();
                break;
            }
            case 73: {
                tag = this.decodeDefineFontAlignZones();
                break;
            }
            case 74: {
                tag = this.decodeCSMTextSettings();
                break;
            }
            case 86: {
                tag = this.decodeDefineSceneAndFrameData(n2);
                break;
            }
            case 88: {
                tag = this.decodeDefineFontName();
                break;
            }
            default: {
                tag = this.decodeUnknown(n2, n);
            }
        }
        int n4 = this.r.getOffset() - n3;
        if (n4 != n2 && n == 18 && n4 != n2 + 2) {
            throw new SwfFormatException(TagValues.names[n] + " at pos " + n3 + ": " + n4 + " bytes were read. " + n2 + " byte were required.");
        }
        return tag;
    }

    private Tag decodeDefineSceneAndFrameData(int n) throws IOException {
        DefineSceneAndFrameLabelData defineSceneAndFrameLabelData = new DefineSceneAndFrameLabelData();
        defineSceneAndFrameLabelData.data = new byte[n];
        this.r.readFully(defineSceneAndFrameLabelData.data);
        return defineSceneAndFrameLabelData;
    }

    private Tag decodeDoABC(int n, int n2) throws IOException {
        DoABC doABC;
        if (n == 82) {
            int n3 = this.r.getOffset();
            int n4 = this.r.readSI32();
            String string = this.r.readString();
            doABC = new DoABC(string, n4);
            n2 -= this.r.getOffset() - n3;
        } else {
            doABC = new DoABC();
        }
        doABC.abc = new byte[n2];
        this.r.readFully(doABC.abc);
        return doABC;
    }

    private Tag decodeSymbolClass() throws IOException {
        SymbolClass symbolClass = new SymbolClass();
        int n = this.r.readUI16();
        symbolClass.class2tag = new HashMap<String, Tag>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.r.readUI16();
            String string = this.r.readString();
            if (n2 == 0) {
                symbolClass.topLevelClass = string;
                continue;
            }
            DefineTag defineTag = this.dict.getTag(n2);
            symbolClass.class2tag.put(string, defineTag);
            if (defineTag.name != null) {
                if (defineTag.name.equals(string)) continue;
                this.handler.error("SymbolClass: symbol " + n2 + " already exported as " + defineTag.name);
                continue;
            }
            DefineTag defineTag2 = this.dict.getTag(string);
            if (defineTag2 != null) {
                int n3 = this.dict.getId(defineTag2);
                this.handler.error("Symbol " + string + " already refers to ID " + n3);
            }
            defineTag.name = string;
            this.dict.addName(defineTag, string);
        }
        return symbolClass;
    }

    private Tag decodeSetTabIndex() throws IOException {
        int n = this.r.readUI16();
        int n2 = this.r.readUI16();
        return new SetTabIndex(n, n2);
    }

    private Tag decodeUnknown(int n, int n2) throws IOException {
        GenericTag genericTag = new GenericTag(n2);
        genericTag.data = new byte[n];
        this.r.readFully(genericTag.data);
        return genericTag;
    }

    private ScriptLimits decodeScriptLimits() throws IOException {
        ScriptLimits scriptLimits = new ScriptLimits(this.r.readUI16(), this.r.readUI16());
        return scriptLimits;
    }

    private Tag decodeDebugID(int n, int n2) throws IOException {
        DebugID debugID = new DebugID(n);
        debugID.uuid = this.decodeFlashUUID(n2);
        if (this.swdIn != null) {
            InputStream inputStream = this.swdIn;
            DebugTable debugTable = new DebugTable();
            new DebugDecoder(inputStream).readSwd(debugTable);
            if (!debugID.uuid.equals(debugTable.uuid)) {
                this.handler.error("SWD uuid " + debugTable.uuid + " doesn't match " + debugID.uuid);
            } else if (debugTable.version != this.getSwfVersion()) {
                this.handler.error("SWD version number " + debugTable.version + " doesn't match SWF version number " + this.getSwfVersion());
            } else {
                this.swd = debugTable;
            }
        } else if (this.swfUrl != null) {
            String string = this.swfUrl.toString();
            int n3 = string.indexOf("?");
            String string2 = null;
            if (n3 != -1) {
                string2 = string.substring(n3);
                string = string.substring(0, n3);
            }
            string = string.endsWith(".swf") ? string.substring(0, string.length() - 4) + ".swd" : string + ".swd";
            if (string2 != null) {
                string = string + string2;
            }
            URL uRL = new URL(string);
            try {
                InputStream inputStream = uRL.openStream();
                DebugTable debugTable = new DebugTable();
                new DebugDecoder(inputStream).readSwd(debugTable);
                if (!debugID.uuid.equals(debugTable.uuid)) {
                    this.handler.error("SWD uuid " + debugTable.uuid + " doesn't match " + debugID.uuid);
                } else if (debugTable.version != this.getSwfVersion()) {
                    this.handler.error("SWD version number " + debugTable.version + " doesn't match SWF version number " + this.getSwfVersion());
                } else {
                    this.swd = debugTable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.handler.error("SWD not found at url " + uRL);
            }
        }
        return debugID;
    }

    private FlashUUID decodeFlashUUID(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.r.readFully(byArray);
        return new FlashUUID(byArray);
    }

    private Tag decodeVideoFrame(int n) throws IOException {
        VideoFrame videoFrame = new VideoFrame();
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        videoFrame.stream = (DefineVideoStream)this.dict.getTag(n3);
        videoFrame.frameNum = this.r.readUI16();
        videoFrame.videoData = new byte[n -= this.r.getOffset() - n2];
        this.r.readFully(videoFrame.videoData);
        return videoFrame;
    }

    private Tag decodeDefineVideoStream() throws IOException {
        DefineVideoStream defineVideoStream = new DefineVideoStream();
        int n = this.r.readUI16();
        defineVideoStream.numFrames = this.r.readUI16();
        defineVideoStream.width = this.r.readUI16();
        defineVideoStream.height = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(4);
        defineVideoStream.deblocking = this.r.readUBits(3);
        defineVideoStream.smoothing = this.r.readBit();
        defineVideoStream.codecID = this.r.readUI8();
        this.dict.add(n, defineVideoStream);
        return defineVideoStream;
    }

    private Tag decodeDoInitAction(int n) throws IOException {
        DoInitAction doInitAction = new DoInitAction();
        int n2 = this.r.readUI16();
        try {
            doInitAction.sprite = (DefineSprite)this.dict.getTag(n2);
            if (doInitAction.sprite.initAction != null) {
                this.handler.error("Sprite " + n2 + " initaction redefined");
            } else {
                doInitAction.sprite.initAction = doInitAction;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.handler.error(illegalArgumentException.getMessage());
        }
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        doInitAction.actionList = actionDecoder.decode(n - 2);
        return doInitAction;
    }

    private Tag decodeEnableDebugger(int n) throws IOException {
        EnableDebugger enableDebugger = new EnableDebugger(n);
        if (n == 64) {
            if (this.getSwfVersion() < 6) {
                this.handler.error("EnableDebugger2 not valid before SWF 6");
            }
            enableDebugger.reserved = this.r.readUI16();
        }
        enableDebugger.password = this.r.readString();
        return enableDebugger;
    }

    private Tag decodeImportAssets(int n) throws IOException {
        ImportAssets importAssets = new ImportAssets(n);
        importAssets.url = this.r.readString();
        if (n == 71) {
            boolean bl = importAssets.downloadNow = this.r.readUI8() == 1;
            if (this.r.readUI8() == 1) {
                importAssets.SHA1 = new byte[20];
                this.r.readFully(importAssets.SHA1);
            }
        }
        int n2 = this.r.readUI16();
        importAssets.importRecords = new ArrayList<ImportRecord>();
        for (int i = 0; i < n2; ++i) {
            ImportRecord importRecord = new ImportRecord();
            int n3 = this.r.readUI16();
            importRecord.name = this.r.readString();
            importAssets.importRecords.add(importRecord);
            this.dict.add(n3, importRecord);
            this.dict.addName(importRecord, importRecord.name);
        }
        return importAssets;
    }

    private Tag decodeExportAssets() throws IOException {
        ExportAssets exportAssets = new ExportAssets();
        int n = this.r.readUI16();
        exportAssets.exports = new ArrayList<Tag>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.r.readUI16();
            String string = this.r.readString();
            DefineTag defineTag = this.dict.getTag(n2);
            exportAssets.exports.add(defineTag);
            if (defineTag.name != null) {
                if (!defineTag.name.equals(string)) {
                    this.handler.error("ExportAsset: symbol " + n2 + " already exported as " + defineTag.name);
                    continue;
                }
                this.handler.error("redundant export of " + defineTag.name);
                continue;
            }
            DefineTag defineTag2 = this.dict.getTag(string);
            if (defineTag2 != null) {
                int n3 = this.dict.getId(defineTag2);
                this.handler.error("Symbol " + string + " already refers to ID " + n3);
            }
            defineTag.name = string;
            this.dict.addName(defineTag, string);
        }
        return exportAssets;
    }

    private Tag decodeDefineFont2() throws IOException {
        DefineFont2 defineFont2 = new DefineFont2();
        return this.decodeDefineFont2And3(defineFont2);
    }

    private Tag decodeDefineFont3() throws IOException {
        DefineFont3 defineFont3 = new DefineFont3();
        return this.decodeDefineFont2And3(defineFont3);
    }

    private Tag decodeDefineFont2And3(DefineFont2 defineFont2) throws IOException {
        int n;
        int n2 = this.r.readUI16();
        this.r.syncBits();
        defineFont2.hasLayout = this.r.readBit();
        defineFont2.shiftJIS = this.r.readBit();
        defineFont2.smallText = this.r.readBit();
        defineFont2.ansi = this.r.readBit();
        defineFont2.wideOffsets = this.r.readBit();
        defineFont2.wideCodes = this.r.readBit();
        defineFont2.italic = this.r.readBit();
        defineFont2.bold = this.r.readBit();
        defineFont2.langCode = this.r.readUI8();
        defineFont2.fontName = this.r.readLengthString();
        int n3 = this.r.readUI16();
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = defineFont2.wideOffsets ? this.r.readUI32() : (long)this.r.readUI16();
        }
        long l = 0L;
        if (n3 > 0) {
            l = defineFont2.wideOffsets ? this.r.readUI32() : (long)this.r.readUI16();
        }
        defineFont2.glyphShapeTable = new Shape[n3];
        for (n = 0; n < n3; ++n) {
            int n4 = n < n3 - 1 ? (int)(lArray[n + 1] - lArray[n]) : (int)(l - lArray[n]);
            defineFont2.glyphShapeTable[n] = this.decodeGlyph(32, n4);
        }
        defineFont2.codeTable = new char[n3];
        if (defineFont2.wideCodes) {
            for (n = 0; n < n3; ++n) {
                defineFont2.codeTable[n] = (char)this.r.readUI16();
            }
        } else {
            for (n = 0; n < n3; ++n) {
                defineFont2.codeTable[n] = (char)this.r.readUI8();
            }
        }
        if (defineFont2.hasLayout) {
            defineFont2.ascent = this.r.readSI16();
            defineFont2.descent = this.r.readSI16();
            defineFont2.leading = this.r.readSI16();
            defineFont2.advanceTable = new short[n3];
            for (n = 0; n < n3; ++n) {
                defineFont2.advanceTable[n] = (short)this.r.readSI16();
            }
            defineFont2.boundsTable = new Rect[n3];
            for (n = 0; n < n3; ++n) {
                defineFont2.boundsTable[n] = this.decodeRect();
            }
            defineFont2.kerningCount = this.r.readUI16();
            defineFont2.kerningTable = new KerningRecord[defineFont2.kerningCount];
            for (n = 0; n < defineFont2.kerningCount; ++n) {
                defineFont2.kerningTable[n] = this.decodeKerningRecord(defineFont2.wideCodes);
            }
        }
        this.dict.add(n2, defineFont2);
        this.dict.addFontFace(defineFont2);
        return defineFont2;
    }

    private Tag decodeDefineFont4(int n) throws IOException {
        DefineFont4 defineFont4 = new DefineFont4();
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(5);
        defineFont4.hasFontData = this.r.readBit();
        defineFont4.italic = this.r.readBit();
        defineFont4.bold = this.r.readBit();
        defineFont4.fontName = this.r.readString();
        if (defineFont4.hasFontData) {
            defineFont4.data = new byte[n -= this.r.getOffset() - n2];
            this.r.readFully(defineFont4.data);
        }
        this.dict.add(n3, defineFont4);
        this.dict.addFontFace(defineFont4);
        return defineFont4;
    }

    private KerningRecord decodeKerningRecord(boolean bl) throws IOException {
        KerningRecord kerningRecord = new KerningRecord();
        kerningRecord.code1 = bl ? this.r.readUI16() : this.r.readUI8();
        kerningRecord.code2 = bl ? this.r.readUI16() : this.r.readUI8();
        kerningRecord.adjustment = this.r.readUI16();
        return kerningRecord;
    }

    private Tag decodeDefineMorphShape() throws IOException {
        return this.decodeDefineMorphShape(46);
    }

    private Tag decodeDefineMorphShape2() throws IOException {
        return this.decodeDefineMorphShape(84);
    }

    private Tag decodeDefineMorphShape(int n) throws IOException {
        DefineMorphShape defineMorphShape = new DefineMorphShape(n);
        int n2 = this.r.readUI16();
        defineMorphShape.startBounds = this.decodeRect();
        defineMorphShape.endBounds = this.decodeRect();
        if (n == 84) {
            defineMorphShape.startEdgeBounds = this.decodeRect();
            defineMorphShape.endEdgeBounds = this.decodeRect();
            this.r.readUBits(6);
            defineMorphShape.usesNonScalingStrokes = this.r.readBit();
            defineMorphShape.usesScalingStrokes = this.r.readBit();
        }
        int n3 = (int)this.r.readUI32();
        defineMorphShape.fillStyles = this.decodeMorphFillstyles(n);
        defineMorphShape.lineStyles = this.decodeMorphLinestyles(n);
        defineMorphShape.startEdges = this.decodeShape(32);
        if (n3 != 0) {
            defineMorphShape.endEdges = this.decodeShape(32);
        }
        this.dict.add(n2, defineMorphShape);
        return defineMorphShape;
    }

    private MorphLineStyle[] decodeMorphLinestyles(int n) throws IOException {
        int n2 = this.r.readUI8();
        if (n2 == 255) {
            n2 = this.r.readUI16();
        }
        MorphLineStyle[] morphLineStyleArray = new MorphLineStyle[n2];
        for (int i = 0; i < n2; ++i) {
            MorphLineStyle morphLineStyle = new MorphLineStyle();
            morphLineStyle.startWidth = this.r.readUI16();
            morphLineStyle.endWidth = this.r.readUI16();
            if (n == 84) {
                morphLineStyle.startCapsStyle = this.r.readUBits(2);
                morphLineStyle.jointStyle = this.r.readUBits(2);
                morphLineStyle.hasFill = this.r.readBit();
                morphLineStyle.noHScale = this.r.readBit();
                morphLineStyle.noVScale = this.r.readBit();
                morphLineStyle.pixelHinting = this.r.readBit();
                this.r.readUBits(5);
                morphLineStyle.noClose = this.r.readBit();
                morphLineStyle.endCapsStyle = this.r.readUBits(2);
                if (morphLineStyle.jointStyle == 2) {
                    morphLineStyle.miterLimit = this.r.readUI16();
                }
            }
            if (!morphLineStyle.hasFill) {
                morphLineStyle.startColor = this.decodeRGBA(this.r);
                morphLineStyle.endColor = this.decodeRGBA(this.r);
            }
            if (morphLineStyle.hasFill) {
                morphLineStyle.fillType = this.decodeMorphFillStyle(n);
            }
            morphLineStyleArray[i] = morphLineStyle;
        }
        return morphLineStyleArray;
    }

    private MorphFillStyle[] decodeMorphFillstyles(int n) throws IOException {
        int n2 = this.r.readUI8();
        if (n2 == 255) {
            n2 = this.r.readUI16();
        }
        MorphFillStyle[] morphFillStyleArray = new MorphFillStyle[n2];
        for (int i = 0; i < n2; ++i) {
            morphFillStyleArray[i] = this.decodeMorphFillStyle(n);
        }
        return morphFillStyleArray;
    }

    private MorphFillStyle decodeMorphFillStyle(int n) throws IOException {
        MorphFillStyle morphFillStyle = new MorphFillStyle();
        morphFillStyle.type = this.r.readUI8();
        switch (morphFillStyle.type) {
            case 0: {
                morphFillStyle.startColor = this.decodeRGBA(this.r);
                morphFillStyle.endColor = this.decodeRGBA(this.r);
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                morphFillStyle.startGradientMatrix = this.decodeMatrix();
                morphFillStyle.endGradientMatrix = this.decodeMatrix();
                morphFillStyle.gradRecords = this.decodeMorphGradient();
                if (morphFillStyle.type != 19 || n != 84) break;
                morphFillStyle.ratio1 = this.r.readSI16();
                morphFillStyle.ratio2 = this.r.readSI16();
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int n2 = this.r.readUI16();
                try {
                    morphFillStyle.bitmap = this.dict.getTag(n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handler.error(illegalArgumentException.getMessage());
                    morphFillStyle.bitmap = null;
                }
                morphFillStyle.startBitmapMatrix = this.decodeMatrix();
                morphFillStyle.endBitmapMatrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + morphFillStyle.type);
            }
        }
        return morphFillStyle;
    }

    private MorphGradRecord[] decodeMorphGradient() throws IOException {
        int n = this.r.readUI8();
        MorphGradRecord[] morphGradRecordArray = new MorphGradRecord[n];
        for (int i = 0; i < n; ++i) {
            MorphGradRecord morphGradRecord = new MorphGradRecord();
            morphGradRecord.startRatio = this.r.readUI8();
            morphGradRecord.startColor = this.decodeRGBA(this.r);
            morphGradRecord.endRatio = this.r.readUI8();
            morphGradRecord.endColor = this.decodeRGBA(this.r);
            morphGradRecordArray[i] = morphGradRecord;
        }
        return morphGradRecordArray;
    }

    private Tag decodeFrameLabel(int n) throws IOException {
        FrameLabel frameLabel = new FrameLabel();
        int n2 = this.r.getOffset();
        frameLabel.label = this.r.readString();
        if (this.getSwfVersion() >= 6 && n - this.r.getOffset() + n2 == 1) {
            int n3 = this.r.readUI8();
            if (n3 != 0 && n3 != 1) {
                this.handler.error("illegal anchor value: " + n3 + ".  Must be 0 or 1");
            }
            frameLabel.anchor = n3 != 0;
        }
        return frameLabel;
    }

    private Tag decodeDefineEditText() throws IOException {
        DefineEditText defineEditText = new DefineEditText();
        int n = this.r.readUI16();
        defineEditText.bounds = this.decodeRect();
        this.r.syncBits();
        defineEditText.hasText = this.r.readBit();
        defineEditText.wordWrap = this.r.readBit();
        defineEditText.multiline = this.r.readBit();
        defineEditText.password = this.r.readBit();
        defineEditText.readOnly = this.r.readBit();
        defineEditText.hasTextColor = this.r.readBit();
        defineEditText.hasMaxLength = this.r.readBit();
        defineEditText.hasFont = this.r.readBit();
        defineEditText.hasFontClass = this.r.readBit();
        defineEditText.autoSize = this.r.readBit();
        defineEditText.hasLayout = this.r.readBit();
        defineEditText.noSelect = this.r.readBit();
        defineEditText.border = this.r.readBit();
        defineEditText.wasStatic = this.r.readBit();
        defineEditText.html = this.r.readBit();
        defineEditText.useOutlines = this.r.readBit();
        if (defineEditText.hasFont) {
            int n2 = this.r.readUI16();
            defineEditText.font = (DefineFont)this.dict.getTag(n2);
            defineEditText.height = this.r.readUI16();
        }
        if (defineEditText.hasFontClass) {
            defineEditText.fontClass = this.r.readString();
            defineEditText.height = this.r.readUI16();
        }
        if (defineEditText.hasTextColor) {
            defineEditText.color = this.decodeRGBA(this.r);
        }
        if (defineEditText.hasMaxLength) {
            defineEditText.maxLength = this.r.readUI16();
        }
        if (defineEditText.hasLayout) {
            defineEditText.align = this.r.readUI8();
            defineEditText.leftMargin = this.r.readUI16();
            defineEditText.rightMargin = this.r.readUI16();
            defineEditText.ident = this.r.readUI16();
            defineEditText.leading = this.r.readSI16();
        }
        defineEditText.varName = this.r.readString();
        if (defineEditText.hasText) {
            defineEditText.initialText = this.r.readString();
        }
        this.dict.add(n, defineEditText);
        return defineEditText;
    }

    private Tag decodeDefineScalingGrid() throws IOException {
        DefineScalingGrid defineScalingGrid = new DefineScalingGrid();
        int n = this.r.readUI16();
        try {
            defineScalingGrid.scalingTarget = this.dict.getTag(n);
            if (defineScalingGrid.scalingTarget instanceof DefineSprite) {
                DefineSprite defineSprite = (DefineSprite)defineScalingGrid.scalingTarget;
                if (defineSprite.scalingGrid != null) {
                    this.handler.error("Sprite " + n + " scaling grid redefined");
                }
                defineSprite.scalingGrid = defineScalingGrid;
            } else if (defineScalingGrid.scalingTarget instanceof DefineButton) {
                DefineButton defineButton = (DefineButton)defineScalingGrid.scalingTarget;
                if (defineButton.scalingGrid != null) {
                    this.handler.error("Button " + n + " scaling grid redefined");
                }
                defineButton.scalingGrid = defineScalingGrid;
            }
        }
        catch (Exception exception) {
            return null;
        }
        defineScalingGrid.rect = this.decodeRect();
        return defineScalingGrid;
    }

    private Tag decodeDefineBitsLossless2(int n) throws IOException {
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless(36);
        SwfDecoder swfDecoder = this.r;
        int n2 = swfDecoder.getOffset();
        int n3 = swfDecoder.readUI16();
        defineBitsLossless.format = swfDecoder.readUI8();
        defineBitsLossless.width = swfDecoder.readUI16();
        defineBitsLossless.height = swfDecoder.readUI16();
        switch (defineBitsLossless.format) {
            case 3: {
                int n4 = swfDecoder.readUI8() + 1;
                byte[] byArray = new byte[n -= swfDecoder.getOffset() - n2];
                swfDecoder.readFully(byArray);
                swfDecoder = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(byArray)), this.getSwfVersion());
                this.decodeAlphaColorMapData(swfDecoder, defineBitsLossless, n4);
                break;
            }
            case 4: 
            case 5: {
                byte[] byArray = new byte[n -= swfDecoder.getOffset() - n2];
                swfDecoder.readFully(byArray);
                swfDecoder = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(byArray)), this.getSwfVersion());
                defineBitsLossless.data = new byte[defineBitsLossless.width * defineBitsLossless.height * 4];
                swfDecoder.readFully(defineBitsLossless.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + defineBitsLossless.format);
            }
        }
        this.dict.add(n3, defineBitsLossless);
        return defineBitsLossless;
    }

    private void decodeAlphaColorMapData(SwfDecoder swfDecoder, DefineBitsLossless defineBitsLossless, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = defineBitsLossless.width;
        int n6 = defineBitsLossless.height;
        defineBitsLossless.colorData = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            defineBitsLossless.colorData[n4] = this.decodeRGBA(swfDecoder);
        }
        if (n5 % 4 != 0) {
            n5 = (n5 / 4 + 1) * 4;
        }
        n4 = n5 * n6;
        defineBitsLossless.data = new byte[n4];
        for (n3 = 0; n3 < n4 && (n2 = swfDecoder.readUI8()) != -1; ++n3) {
            defineBitsLossless.data[n3] = (byte)n2;
        }
        int n7 = 0;
        while (swfDecoder.readUI8() != -1) {
            ++n7;
        }
        if (n7 > 0) {
            throw new SwfFormatException(n7 + " bytes of bitmap data (" + n5 + "x" + n6 + ") not read!");
        }
        if (n3 != n4) {
            throw new SwfFormatException("(" + n5 + "x" + n6 + ") data buffer " + (n4 - n3) + " bytes too big...");
        }
    }

    private Tag decodeDefineJPEG3(int n) throws IOException {
        int n2;
        DefineBitsJPEG3 defineBitsJPEG3 = new DefineBitsJPEG3();
        int n3 = this.r.getOffset();
        int n4 = this.r.readUI16();
        defineBitsJPEG3.alphaDataOffset = this.r.readUI32();
        defineBitsJPEG3.data = new byte[(int)defineBitsJPEG3.alphaDataOffset];
        this.r.readFully(defineBitsJPEG3.data);
        byte[] byArray = new byte[n -= this.r.getOffset() - n3];
        this.r.readFully(byArray);
        SwfDecoder swfDecoder = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(byArray)), this.getSwfVersion());
        int n5 = 0;
        byte[] byArray2 = new byte[n];
        while ((n2 = swfDecoder.readUI8()) != -1) {
            if (n5 == byArray2.length) {
                byte[] byArray3 = new byte[n5 + n];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                byArray2 = byArray3;
            }
            byArray2[n5] = (byte)n2;
            ++n5;
        }
        defineBitsJPEG3.alphaData = new byte[n5];
        System.arraycopy(byArray2, 0, defineBitsJPEG3.alphaData, 0, n5);
        this.dict.add(n4, defineBitsJPEG3);
        return defineBitsJPEG3;
    }

    private Tag decodeDefineButton2(int n) throws IOException {
        int n2;
        ButtonRecord buttonRecord;
        int n3 = this.r.getOffset() + n;
        DefineButton defineButton = new DefineButton(34);
        int n4 = this.r.readUI16();
        this.r.syncBits();
        this.r.readUBits(7);
        defineButton.trackAsMenu = this.r.readBit();
        int n5 = this.r.readUI16();
        ArrayList<Object> arrayList = new ArrayList<Object>(5);
        while ((buttonRecord = this.decodeButtonRecord(defineButton.code)) != null) {
            arrayList.add(buttonRecord);
        }
        defineButton.buttonRecords = new ButtonRecord[arrayList.size()];
        arrayList.toArray(defineButton.buttonRecords);
        arrayList.clear();
        if (n5 > 0) {
            arrayList = new ArrayList();
            n2 = this.r.getOffset();
            while ((n5 = this.r.readUI16()) > 0) {
                arrayList.add(this.decodeButtonCondAction(n5 - 2));
                if (this.r.getOffset() != n2 + n5) {
                    throw new SwfFormatException("incorrect offset read in ButtonCondAction. read " + n5 + "");
                }
                n2 = this.r.getOffset();
            }
            arrayList.add(this.decodeButtonCondAction(n3 - this.r.getOffset()));
            defineButton.condActions = new ButtonCondAction[arrayList.size()];
            arrayList.toArray(defineButton.condActions);
        } else {
            defineButton.condActions = new ButtonCondAction[0];
        }
        while (this.r.getOffset() < n3) {
            n2 = this.r.readUI8();
            if (n2 == 0) continue;
            throw new SwfFormatException("nonzero data past end of DefineButton2");
        }
        this.dict.add(n4, defineButton);
        return defineButton;
    }

    private ButtonCondAction decodeButtonCondAction(int n) throws IOException {
        ButtonCondAction buttonCondAction = new ButtonCondAction();
        this.r.syncBits();
        buttonCondAction.keyPress = this.r.readUBits(7);
        buttonCondAction.overDownToIdle = this.r.readBit();
        buttonCondAction.idleToOverDown = this.r.readBit();
        buttonCondAction.outDownToIdle = this.r.readBit();
        buttonCondAction.outDownToOverDown = this.r.readBit();
        buttonCondAction.overDownToOutDown = this.r.readBit();
        buttonCondAction.overDownToOverUp = this.r.readBit();
        buttonCondAction.overUpToOverDown = this.r.readBit();
        buttonCondAction.overUpToIdle = this.r.readBit();
        buttonCondAction.idleToOverUp = this.r.readBit();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        buttonCondAction.actionList = actionDecoder.decode(n - 2);
        return buttonCondAction;
    }

    private Tag decodePlaceObject23(int n, int n2) throws IOException {
        PlaceObject placeObject = new PlaceObject(n);
        int n3 = this.r.getOffset();
        placeObject.flags = this.r.readUI8();
        if (n == 70) {
            placeObject.flags2 = this.r.readUI8();
        }
        placeObject.depth = this.r.readUI16();
        if (placeObject.hasClassName()) {
            placeObject.className = this.r.readString();
        }
        if (placeObject.hasCharID()) {
            int n4 = this.r.readUI16();
            placeObject.setRef(this.dict.getTag(n4));
        }
        if (placeObject.hasMatrix()) {
            placeObject.matrix = this.decodeMatrix();
        }
        if (placeObject.hasCxform()) {
            placeObject.setCxform(this.decodeCxforma());
        }
        if (placeObject.hasRatio()) {
            placeObject.ratio = this.r.readUI16();
        }
        if (placeObject.hasName()) {
            placeObject.name = this.r.readString();
        }
        if (placeObject.hasClipDepth()) {
            placeObject.clipDepth = this.r.readUI16();
        }
        if (n == 70) {
            if (placeObject.hasFilterList()) {
                placeObject.filters = this.decodeFilterList();
            }
            if (placeObject.hasBlendMode()) {
                placeObject.blendMode = this.r.readUI8();
            }
        }
        if (placeObject.hasClipAction()) {
            ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
            actionDecoder.setKeepOffsets(this.keepOffsets);
            placeObject.clipActions = actionDecoder.decodeClipActions(n2 - (this.r.getOffset() - n3));
        }
        return placeObject;
    }

    private List<Filter> decodeFilterList() throws IOException {
        LinkedList<Filter> linkedList = new LinkedList<Filter>();
        int n = this.r.readUI8();
        block10: for (int i = 0; i < n; ++i) {
            int n2 = this.r.readUI8();
            switch (n2) {
                case 0: {
                    linkedList.add(this.decodeDropShadowFilter());
                    continue block10;
                }
                case 1: {
                    linkedList.add(this.decodeBlurFilter());
                    continue block10;
                }
                case 2: {
                    linkedList.add(this.decodeGlowFilter());
                    continue block10;
                }
                case 3: {
                    linkedList.add(this.decodeBevelFilter());
                    continue block10;
                }
                case 4: {
                    linkedList.add(this.decodeGradientGlowFilter());
                    continue block10;
                }
                case 5: {
                    linkedList.add(this.decodeConvolutionFilter());
                    continue block10;
                }
                case 6: {
                    linkedList.add(this.decodeColorMatrixFilter());
                    continue block10;
                }
                case 7: {
                    linkedList.add(this.decodeGradientBevelFilter());
                }
            }
        }
        return linkedList;
    }

    private DropShadowFilter decodeDropShadowFilter() throws IOException {
        DropShadowFilter dropShadowFilter = new DropShadowFilter();
        dropShadowFilter.color = this.decodeRGBA(this.r);
        dropShadowFilter.blurX = this.r.readSI32();
        dropShadowFilter.blurY = this.r.readSI32();
        dropShadowFilter.angle = this.r.readSI32();
        dropShadowFilter.distance = this.r.readSI32();
        dropShadowFilter.strength = this.r.readUI16();
        dropShadowFilter.flags = this.r.readUI8();
        return dropShadowFilter;
    }

    private BlurFilter decodeBlurFilter() throws IOException {
        BlurFilter blurFilter = new BlurFilter();
        blurFilter.blurX = this.r.readSI32();
        blurFilter.blurY = this.r.readSI32();
        blurFilter.passes = this.r.readUI8();
        return blurFilter;
    }

    private GlowFilter decodeGlowFilter() throws IOException {
        GlowFilter glowFilter = new GlowFilter();
        glowFilter.color = this.decodeRGBA(this.r);
        glowFilter.blurX = this.r.readSI32();
        glowFilter.blurY = this.r.readSI32();
        glowFilter.strength = this.r.readUI16();
        glowFilter.flags = this.r.readUI8();
        return glowFilter;
    }

    private BevelFilter decodeBevelFilter() throws IOException {
        BevelFilter bevelFilter = new BevelFilter();
        bevelFilter.highlightColor = this.decodeRGBA(this.r);
        bevelFilter.shadowColor = this.decodeRGBA(this.r);
        bevelFilter.blurX = this.r.readSI32();
        bevelFilter.blurY = this.r.readSI32();
        bevelFilter.angle = this.r.readSI32();
        bevelFilter.distance = this.r.readSI32();
        bevelFilter.strength = this.r.readUI16();
        bevelFilter.flags = this.r.readUI8();
        return bevelFilter;
    }

    private GradientGlowFilter decodeGradientGlowFilter() throws IOException {
        int n;
        GradientGlowFilter gradientGlowFilter = new GradientGlowFilter();
        gradientGlowFilter.numcolors = this.r.readUI8();
        gradientGlowFilter.gradientColors = new int[gradientGlowFilter.numcolors];
        for (n = 0; n < gradientGlowFilter.numcolors; ++n) {
            gradientGlowFilter.gradientColors[n] = this.decodeRGBA(this.r);
        }
        gradientGlowFilter.gradientRatio = new int[gradientGlowFilter.numcolors];
        for (n = 0; n < gradientGlowFilter.numcolors; ++n) {
            gradientGlowFilter.gradientRatio[n] = this.r.readUI8();
        }
        gradientGlowFilter.blurX = this.r.readSI32();
        gradientGlowFilter.blurY = this.r.readSI32();
        gradientGlowFilter.angle = this.r.readSI32();
        gradientGlowFilter.distance = this.r.readSI32();
        gradientGlowFilter.strength = this.r.readUI16();
        gradientGlowFilter.flags = this.r.readUI8();
        return gradientGlowFilter;
    }

    private ConvolutionFilter decodeConvolutionFilter() throws IOException {
        ConvolutionFilter convolutionFilter = new ConvolutionFilter();
        convolutionFilter.matrixX = this.r.readUI8();
        convolutionFilter.matrixY = this.r.readUI8();
        convolutionFilter.divisor = this.r.readFloat();
        convolutionFilter.bias = this.r.readFloat();
        convolutionFilter.matrix = new float[convolutionFilter.matrixX * convolutionFilter.matrixY];
        for (int i = 0; i < convolutionFilter.matrixX * convolutionFilter.matrixY; ++i) {
            convolutionFilter.matrix[i] = this.r.readFloat();
        }
        convolutionFilter.color = this.decodeRGBA(this.r);
        convolutionFilter.flags = this.r.readUI8();
        return convolutionFilter;
    }

    private ColorMatrixFilter decodeColorMatrixFilter() throws IOException {
        ColorMatrixFilter colorMatrixFilter = new ColorMatrixFilter();
        for (int i = 0; i < 20; ++i) {
            colorMatrixFilter.values[i] = this.r.readFloat();
        }
        return colorMatrixFilter;
    }

    private GradientBevelFilter decodeGradientBevelFilter() throws IOException {
        int n;
        GradientBevelFilter gradientBevelFilter = new GradientBevelFilter();
        gradientBevelFilter.numcolors = this.r.readUI8();
        gradientBevelFilter.gradientColors = new int[gradientBevelFilter.numcolors];
        for (n = 0; n < gradientBevelFilter.numcolors; ++n) {
            gradientBevelFilter.gradientColors[n] = this.decodeRGBA(this.r);
        }
        gradientBevelFilter.gradientRatio = new int[gradientBevelFilter.numcolors];
        for (n = 0; n < gradientBevelFilter.numcolors; ++n) {
            gradientBevelFilter.gradientRatio[n] = this.r.readUI8();
        }
        gradientBevelFilter.blurX = this.r.readSI32();
        gradientBevelFilter.blurY = this.r.readSI32();
        gradientBevelFilter.angle = this.r.readSI32();
        gradientBevelFilter.distance = this.r.readSI32();
        gradientBevelFilter.strength = this.r.readUI16();
        gradientBevelFilter.flags = this.r.readUI8();
        return gradientBevelFilter;
    }

    private Tag decodePlaceObject(int n) throws IOException {
        PlaceObject placeObject = new PlaceObject(4);
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        placeObject.depth = this.r.readUI16();
        placeObject.setMatrix(this.decodeMatrix());
        if (n - this.r.getOffset() + n2 != 0) {
            placeObject.setCxform(this.decodeCxform());
        }
        placeObject.setRef(this.dict.getTag(n3));
        return placeObject;
    }

    private Tag decodePlaceObject2(int n) throws IOException {
        PlaceObject placeObject = new PlaceObject(26);
        this.r.syncBits();
        int n2 = this.r.getOffset();
        placeObject.flags = this.r.readUI8();
        placeObject.depth = this.r.readUI16();
        if (placeObject.hasCharID()) {
            int n3 = this.r.readUI16();
            placeObject.ref = this.dict.getTag(n3);
        }
        if (placeObject.hasMatrix()) {
            placeObject.matrix = this.decodeMatrix();
        }
        if (placeObject.hasCxform()) {
            placeObject.colorTransform = this.decodeCxforma();
        }
        if (placeObject.hasRatio()) {
            placeObject.ratio = this.r.readUI16();
        }
        if (placeObject.hasName()) {
            placeObject.name = this.r.readString();
        }
        if (placeObject.hasClipDepth()) {
            placeObject.clipDepth = this.r.readUI16();
        }
        if (placeObject.hasClipAction()) {
            ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
            actionDecoder.setKeepOffsets(this.keepOffsets);
            placeObject.clipActions = actionDecoder.decodeClipActions(n - (this.r.getOffset() - n2));
        }
        return placeObject;
    }

    private CXFormWithAlpha decodeCxforma() throws IOException {
        CXFormWithAlpha cXFormWithAlpha = new CXFormWithAlpha();
        this.r.syncBits();
        cXFormWithAlpha.hasAdd = this.r.readBit();
        cXFormWithAlpha.hasMult = this.r.readBit();
        int n = this.r.readUBits(4);
        if (cXFormWithAlpha.hasMult) {
            cXFormWithAlpha.redMultTerm = this.r.readSBits(n);
            cXFormWithAlpha.greenMultTerm = this.r.readSBits(n);
            cXFormWithAlpha.blueMultTerm = this.r.readSBits(n);
            cXFormWithAlpha.alphaMultTerm = this.r.readSBits(n);
        }
        if (cXFormWithAlpha.hasAdd) {
            cXFormWithAlpha.redAddTerm = this.r.readSBits(n);
            cXFormWithAlpha.greenAddTerm = this.r.readSBits(n);
            cXFormWithAlpha.blueAddTerm = this.r.readSBits(n);
            cXFormWithAlpha.alphaAddTerm = this.r.readSBits(n);
        }
        return cXFormWithAlpha;
    }

    private Tag decodeProtect(int n) throws IOException {
        GenericTag genericTag = new GenericTag(24);
        genericTag.data = new byte[n];
        this.r.readFully(genericTag.data);
        return genericTag;
    }

    private Tag decodeDefineButtonCxform() throws IOException {
        DefineButtonCxform defineButtonCxform = new DefineButtonCxform();
        int n = this.r.readUI16();
        defineButtonCxform.button = (DefineButton)this.dict.getTag(n);
        if (defineButtonCxform.button.cxform != null) {
            this.handler.error("button " + this.dict.getId(defineButtonCxform.button) + " cxform redefined");
        }
        defineButtonCxform.button.cxform = defineButtonCxform;
        defineButtonCxform.colorTransform = this.decodeCxform();
        return defineButtonCxform;
    }

    private Tag decodeDefineJPEG2(int n) throws IOException {
        DefineBits defineBits = new DefineBits(21);
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        defineBits.data = new byte[n -= this.r.getOffset() - n2];
        this.r.readFully(defineBits.data);
        this.dict.add(n3, defineBits);
        return defineBits;
    }

    private Tag decodeDefineBitsLossless(int n) throws IOException {
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless(20);
        SwfDecoder swfDecoder = this.r;
        int n2 = swfDecoder.getOffset();
        int n3 = swfDecoder.readUI16();
        defineBitsLossless.format = swfDecoder.readUI8();
        defineBitsLossless.width = swfDecoder.readUI16();
        defineBitsLossless.height = swfDecoder.readUI16();
        switch (defineBitsLossless.format) {
            case 3: {
                int n4 = swfDecoder.readUI8() + 1;
                byte[] byArray = new byte[n -= swfDecoder.getOffset() - n2];
                swfDecoder.readFully(byArray);
                swfDecoder = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(byArray)), this.getSwfVersion());
                this.decodeColorMapData(swfDecoder, defineBitsLossless, n4);
                break;
            }
            case 4: 
            case 5: {
                byte[] byArray = new byte[n -= swfDecoder.getOffset() - n2];
                swfDecoder.readFully(byArray);
                swfDecoder = new SwfDecoder(new InflaterInputStream(new ByteArrayInputStream(byArray)), this.getSwfVersion());
                defineBitsLossless.data = new byte[defineBitsLossless.width * defineBitsLossless.height * 4];
                swfDecoder.readFully(defineBitsLossless.data);
                break;
            }
            default: {
                throw new SwfFormatException("Illegal bitmap format " + defineBitsLossless.format);
            }
        }
        this.dict.add(n3, defineBitsLossless);
        return defineBitsLossless;
    }

    private void decodeColorMapData(SwfDecoder swfDecoder, DefineBitsLossless defineBitsLossless, int n) throws IOException {
        int n2;
        defineBitsLossless.colorData = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            defineBitsLossless.colorData[n2] = this.decodeRGB(swfDecoder);
        }
        n2 = defineBitsLossless.width;
        int n3 = defineBitsLossless.height;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        defineBitsLossless.data = new byte[n2 * n3];
        swfDecoder.readFully(defineBitsLossless.data);
    }

    private Tag decodeSoundStreamBlock(int n) throws IOException {
        GenericTag genericTag = new GenericTag(19);
        genericTag.data = new byte[n];
        this.r.readFully(genericTag.data);
        return genericTag;
    }

    private Tag decodeSoundStreamHead(int n) throws IOException {
        SoundStreamHead soundStreamHead = new SoundStreamHead(n);
        this.r.syncBits();
        this.r.readUBits(4);
        soundStreamHead.playbackRate = this.r.readUBits(2);
        soundStreamHead.playbackSize = this.r.readUBits(1);
        soundStreamHead.playbackType = this.r.readUBits(1);
        soundStreamHead.compression = this.r.readUBits(4);
        soundStreamHead.streamRate = this.r.readUBits(2);
        soundStreamHead.streamSize = this.r.readUBits(1);
        soundStreamHead.streamType = this.r.readUBits(1);
        soundStreamHead.streamSampleCount = this.r.readUI16();
        if (soundStreamHead.compression == 2) {
            soundStreamHead.latencySeek = this.r.readSI16();
        }
        return soundStreamHead;
    }

    private Tag decodeDefineButtonSound() throws IOException {
        DefineButtonSound defineButtonSound = new DefineButtonSound();
        int n = this.r.readUI16();
        defineButtonSound.button = (DefineButton)this.dict.getTag(n);
        if (defineButtonSound.button.sounds != null) {
            this.handler.error("button " + n + " sound redefined");
        }
        defineButtonSound.button.sounds = defineButtonSound;
        n = this.r.readUI16();
        if (n != 0) {
            defineButtonSound.sound0 = this.dict.getTag(n);
            defineButtonSound.info0 = this.decodeSoundInfo();
        }
        if ((n = this.r.readUI16()) != 0) {
            defineButtonSound.sound1 = this.dict.getTag(n);
            defineButtonSound.info1 = this.decodeSoundInfo();
        }
        if ((n = this.r.readUI16()) != 0) {
            defineButtonSound.sound2 = this.dict.getTag(n);
            defineButtonSound.info2 = this.decodeSoundInfo();
        }
        if ((n = this.r.readUI16()) != 0) {
            defineButtonSound.sound3 = this.dict.getTag(n);
            defineButtonSound.info3 = this.decodeSoundInfo();
        }
        return defineButtonSound;
    }

    private Tag decodeStartSound() throws IOException {
        StartSound startSound = new StartSound();
        int n = this.r.readUI16();
        startSound.sound = (DefineSound)this.dict.getTag(n);
        startSound.soundInfo = this.decodeSoundInfo();
        return startSound;
    }

    private SoundInfo decodeSoundInfo() throws IOException {
        SoundInfo soundInfo = new SoundInfo();
        this.r.syncBits();
        this.r.readUBits(2);
        soundInfo.syncStop = this.r.readBit();
        soundInfo.syncNoMultiple = this.r.readBit();
        boolean bl = this.r.readBit();
        boolean bl2 = this.r.readBit();
        boolean bl3 = this.r.readBit();
        boolean bl4 = this.r.readBit();
        if (bl4) {
            soundInfo.inPoint = this.r.readUI32();
        }
        if (bl3) {
            soundInfo.outPoint = this.r.readUI32();
        }
        if (bl2) {
            soundInfo.loopCount = this.r.readUI16();
        }
        if (bl) {
            int n = this.r.readUI8();
            soundInfo.records = new long[n];
            for (int i = 0; i < n; ++i) {
                soundInfo.records[i] = this.r.read64();
            }
        }
        return soundInfo;
    }

    private Tag decodeDefineSound(int n) throws IOException {
        DefineSound defineSound = new DefineSound();
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        this.r.syncBits();
        defineSound.format = this.r.readUBits(4);
        defineSound.rate = this.r.readUBits(2);
        defineSound.size = this.r.readUBits(1);
        defineSound.type = this.r.readUBits(1);
        defineSound.sampleCount = this.r.readUI32();
        defineSound.data = new byte[n -= this.r.getOffset() - n2];
        this.r.readFully(defineSound.data);
        this.dict.add(n3, defineSound);
        return defineSound;
    }

    private Tag decodeDefineFontInfo(int n, int n2) throws IOException {
        DefineFontInfo defineFontInfo = new DefineFontInfo(n);
        int n3 = this.r.getOffset();
        int n4 = this.r.readUI16();
        defineFontInfo.font = (DefineFont1)this.dict.getTag(n4);
        if (defineFontInfo.font.fontInfo != null) {
            this.handler.error("font " + n4 + " info redefined");
        }
        defineFontInfo.font.fontInfo = defineFontInfo;
        defineFontInfo.name = this.r.readLengthString();
        this.r.syncBits();
        this.r.readUBits(3);
        defineFontInfo.shiftJIS = this.r.readBit();
        defineFontInfo.ansi = this.r.readBit();
        defineFontInfo.italic = this.r.readBit();
        defineFontInfo.bold = this.r.readBit();
        defineFontInfo.wideCodes = this.r.readBit();
        if (n == 62) {
            if (!defineFontInfo.wideCodes) {
                this.handler.error("widecodes must be true in DefineFontInfo2");
            }
            if (this.getSwfVersion() < 6) {
                this.handler.error("DefineFont2 not valid before SWF6");
            }
            defineFontInfo.langCode = this.r.readUI8();
        }
        n2 -= this.r.getOffset() - n3;
        if (defineFontInfo.wideCodes) {
            defineFontInfo.codeTable = new char[n2 /= 2];
            for (int i = 0; i < n2; ++i) {
                defineFontInfo.codeTable[i] = (char)this.r.readUI16();
            }
        } else {
            defineFontInfo.codeTable = new char[n2];
            for (int i = 0; i < n2; ++i) {
                defineFontInfo.codeTable[i] = (char)this.r.readUI8();
            }
        }
        return defineFontInfo;
    }

    private Tag decodeDoAction(int n) throws IOException {
        DoAction doAction = new DoAction();
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        doAction.actionList = actionDecoder.decode(n);
        return doAction;
    }

    private Tag decodeDefineText(int n) throws IOException {
        int n2;
        DefineText defineText = new DefineText(n);
        int n3 = this.r.readUI16();
        defineText.bounds = this.decodeRect();
        defineText.matrix = this.decodeMatrix();
        int n4 = this.r.readUI8();
        int n5 = this.r.readUI8();
        ArrayList<TextRecord> arrayList = new ArrayList<TextRecord>(2);
        while ((n2 = this.r.readUI8()) != 0) {
            arrayList.add(this.decodeTextRecord(n, n2, n4, n5));
        }
        defineText.records = arrayList;
        this.dict.add(n3, defineText);
        return defineText;
    }

    private GlyphEntry[] decodeGlyphEntries(int n, int n2, int n3) throws IOException {
        GlyphEntry[] glyphEntryArray = new GlyphEntry[n3];
        this.r.syncBits();
        for (int i = 0; i < n3; ++i) {
            GlyphEntry glyphEntry = new GlyphEntry();
            glyphEntry.setIndex(this.r.readUBits(n));
            glyphEntry.advance = this.r.readSBits(n2);
            glyphEntryArray[i] = glyphEntry;
        }
        return glyphEntryArray;
    }

    private TextRecord decodeTextRecord(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        TextRecord textRecord = new TextRecord();
        textRecord.flags = n2;
        if (textRecord.hasFont()) {
            n5 = this.r.readUI16();
            textRecord.font = (DefineFont)this.dict.getTag(n5);
        }
        if (textRecord.hasColor()) {
            switch (n) {
                case 11: {
                    textRecord.color = this.decodeRGB(this.r);
                    break;
                }
                case 33: {
                    textRecord.color = this.decodeRGBA(this.r);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (textRecord.hasX()) {
            textRecord.xOffset = this.r.readSI16();
        }
        if (textRecord.hasY()) {
            textRecord.yOffset = this.r.readSI16();
        }
        if (textRecord.hasHeight()) {
            textRecord.height = this.r.readUI16();
        }
        n5 = this.r.readUI8();
        textRecord.entries = this.decodeGlyphEntries(n3, n4, n5);
        return textRecord;
    }

    private Tag decodeDefineFont() throws IOException {
        int n;
        DefineFont1 defineFont1 = new DefineFont1();
        int n2 = this.r.readUI16();
        int n3 = this.r.readUI16();
        int n4 = n3 / 2;
        defineFont1.glyphShapeTable = new Shape[n4];
        for (n = 1; n < n4; ++n) {
            this.r.readUI16();
        }
        for (n = 0; n < n4; ++n) {
            defineFont1.glyphShapeTable[n] = this.decodeShape(32);
        }
        this.dict.add(n2, defineFont1);
        this.dict.addFontFace(defineFont1);
        return defineFont1;
    }

    private Tag decodeSetBackgroundColor() throws IOException {
        SetBackgroundColor setBackgroundColor = new SetBackgroundColor(this.decodeRGB(this.r));
        return setBackgroundColor;
    }

    private GenericTag decodeJPEGTables(int n) throws IOException {
        GenericTag genericTag = new GenericTag(8);
        genericTag.data = new byte[n];
        this.r.readFully(genericTag.data);
        return genericTag;
    }

    private Tag decodeDefineButton(int n) throws IOException {
        ButtonRecord buttonRecord;
        int n2 = this.r.getOffset();
        DefineButton defineButton = new DefineButton(7);
        int n3 = this.r.readUI16();
        ArrayList<ButtonRecord> arrayList = new ArrayList<ButtonRecord>();
        do {
            if ((buttonRecord = this.decodeButtonRecord(defineButton.code)) == null) continue;
            arrayList.add(buttonRecord);
        } while (buttonRecord != null);
        defineButton.buttonRecords = new ButtonRecord[arrayList.size()];
        arrayList.toArray(defineButton.buttonRecords);
        int n4 = this.r.getOffset() - n2;
        defineButton.condActions = new ButtonCondAction[1];
        defineButton.condActions[0].overDownToOverUp = true;
        ActionDecoder actionDecoder = new ActionDecoder(this.r, this.swd);
        actionDecoder.setKeepOffsets(this.keepOffsets);
        defineButton.condActions[0].actionList = actionDecoder.decode(n - n4);
        defineButton.trackAsMenu = false;
        this.dict.add(n3, defineButton);
        return defineButton;
    }

    private ButtonRecord decodeButtonRecord(int n) throws IOException {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        ButtonRecord buttonRecord = new ButtonRecord();
        this.r.syncBits();
        if (n == 34) {
            n2 = this.r.readUBits(2);
            bl2 = this.r.readBit();
            bl = this.r.readBit();
        } else {
            n2 = this.r.readUBits(4);
        }
        buttonRecord.hitTest = this.r.readBit();
        buttonRecord.down = this.r.readBit();
        buttonRecord.over = this.r.readBit();
        buttonRecord.up = this.r.readBit();
        if (!(n2 != 0 || buttonRecord.hitTest || buttonRecord.down || buttonRecord.over || buttonRecord.up)) {
            return null;
        }
        int n3 = this.r.readUI16();
        buttonRecord.characterRef = this.dict.getTag(n3);
        buttonRecord.placeDepth = this.r.readUI16();
        buttonRecord.placeMatrix = this.decodeMatrix();
        if (n == 34) {
            buttonRecord.colorTransform = this.decodeCxforma();
            if (bl) {
                buttonRecord.filters = this.decodeFilterList();
            }
            if (bl2) {
                buttonRecord.blendMode = this.r.readUI8();
            }
        }
        return buttonRecord;
    }

    private Tag decodeDefineBinaryData(int n) throws IOException {
        DefineBinaryData defineBinaryData = new DefineBinaryData();
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        defineBinaryData.reserved = this.r.readSI32();
        defineBinaryData.data = new byte[n -= this.r.getOffset() - n2];
        this.r.readFully(defineBinaryData.data);
        this.dict.add(n3, defineBinaryData);
        return defineBinaryData;
    }

    private Tag decodeDefineBits(int n) throws IOException {
        DefineBits defineBits = new DefineBits(6);
        int n2 = this.r.getOffset();
        int n3 = this.r.readUI16();
        defineBits.data = new byte[n -= this.r.getOffset() - n2];
        this.r.readFully(defineBits.data);
        defineBits.jpegTables = this.jpegTables;
        this.dict.add(n3, defineBits);
        return defineBits;
    }

    private Tag decodeRemoveObject(int n) throws IOException {
        RemoveObject removeObject = new RemoveObject(n);
        if (n == 5) {
            int n2 = this.r.readUI16();
            removeObject.ref = this.dict.getTag(n2);
        }
        removeObject.depth = this.r.readUI16();
        return removeObject;
    }

    private CXForm decodeCxform() throws IOException {
        CXForm cXForm = new CXForm();
        this.r.syncBits();
        cXForm.hasAdd = this.r.readBit();
        cXForm.hasMult = this.r.readBit();
        int n = this.r.readUBits(4);
        if (cXForm.hasMult) {
            cXForm.redMultTerm = this.r.readSBits(n);
            cXForm.greenMultTerm = this.r.readSBits(n);
            cXForm.blueMultTerm = this.r.readSBits(n);
        }
        if (cXForm.hasAdd) {
            cXForm.redAddTerm = this.r.readSBits(n);
            cXForm.greenAddTerm = this.r.readSBits(n);
            cXForm.blueAddTerm = this.r.readSBits(n);
        }
        return cXForm;
    }

    private Tag decodeMetadata() throws IOException {
        Metadata metadata = new Metadata();
        metadata.xml = this.r.readString();
        return metadata;
    }

    private Tag decodeDefineShape(int n) throws IOException {
        DefineShape defineShape = new DefineShape(n);
        int n2 = this.r.readUI16();
        defineShape.bounds = this.decodeRect();
        if (n == 83) {
            defineShape.edgeBounds = this.decodeRect();
            this.r.readUBits(5);
            defineShape.usesFillWindingRule = this.r.readBit();
            defineShape.usesNonScalingStrokes = this.r.readBit();
            defineShape.usesScalingStrokes = this.r.readBit();
        }
        defineShape.shapeWithStyle = this.decodeShapeWithStyle(n);
        this.dict.add(n2, defineShape);
        return defineShape;
    }

    private ShapeWithStyle decodeShapeWithStyle(int n) throws IOException {
        ShapeWithStyle shapeWithStyle = new ShapeWithStyle();
        this.r.syncBits();
        shapeWithStyle.fillstyles = this.decodeFillstyles(n);
        shapeWithStyle.linestyles = this.decodeLinestyles(n);
        Shape shape = this.decodeShape(n);
        shapeWithStyle.shapeRecords = shape.shapeRecords;
        return shapeWithStyle;
    }

    private ArrayList<LineStyle> decodeLinestyles(int n) throws IOException {
        ArrayList<LineStyle> arrayList = new ArrayList<LineStyle>();
        int n2 = this.r.readUI8();
        if (n2 == 255) {
            n2 = this.r.readUI16();
        }
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.decodeLineStyle(n));
        }
        return arrayList;
    }

    private LineStyle decodeLineStyle(int n) throws IOException {
        LineStyle lineStyle = new LineStyle();
        lineStyle.width = this.r.readUI16();
        if (n == 83) {
            lineStyle.flags = this.r.readUI16();
            if (lineStyle.hasMiterJoint()) {
                lineStyle.miterLimit = this.r.readUI16();
            }
        }
        if (n == 83 && lineStyle.hasFillStyle()) {
            lineStyle.fillStyle = this.decodeFillStyle(n);
        } else {
            lineStyle.color = n == 32 || n == 83 ? this.decodeRGBA(this.r) : this.decodeRGB(this.r);
        }
        return lineStyle;
    }

    private ArrayList<FillStyle> decodeFillstyles(int n) throws IOException {
        ArrayList<FillStyle> arrayList = new ArrayList<FillStyle>();
        int n2 = this.r.readUI8();
        if (n2 == 255) {
            n2 = this.r.readUI16();
        }
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.decodeFillStyle(n));
        }
        return arrayList;
    }

    private FillStyle decodeFillStyle(int n) throws IOException {
        FillStyle fillStyle = new FillStyle();
        fillStyle.type = this.r.readUI8();
        switch (fillStyle.type) {
            case 0: {
                if (n == 32 || n == 83) {
                    fillStyle.color = this.decodeRGBA(this.r);
                    break;
                }
                if (n == 22 || n == 2) {
                    fillStyle.color = this.decodeRGB(this.r);
                    break;
                }
                throw new SwfFormatException("bad shape code");
            }
            case 16: 
            case 18: 
            case 19: {
                fillStyle.matrix = this.decodeMatrix();
                fillStyle.gradient = this.decodeGradient(n, fillStyle.type);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                int n2 = this.r.readUI16();
                try {
                    fillStyle.bitmap = this.dict.getTag(n2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    fillStyle.bitmap = null;
                    this.handler.error(illegalArgumentException.getMessage());
                }
                fillStyle.matrix = this.decodeMatrix();
                break;
            }
            default: {
                throw new SwfFormatException("unrecognized fill style type: " + fillStyle.type);
            }
        }
        return fillStyle;
    }

    private Gradient decodeGradient(int n, int n2) throws IOException {
        Gradient gradient = n2 == 19 ? new FocalGradient() : new Gradient();
        this.r.syncBits();
        gradient.spreadMode = this.r.readUBits(2);
        gradient.interpolationMode = this.r.readUBits(2);
        int n3 = this.r.readUBits(4);
        gradient.records = new GradRecord[n3];
        for (int i = 0; i < n3; ++i) {
            gradient.records[i] = this.decodeGradRecord(n);
        }
        if (n2 == 19) {
            gradient.focalPoint = this.r.readFixed8();
        }
        return gradient;
    }

    private GradRecord decodeGradRecord(int n) throws IOException {
        GradRecord gradRecord = new GradRecord();
        gradRecord.ratio = this.r.readUI8();
        switch (n) {
            case 2: 
            case 22: {
                gradRecord.color = this.decodeRGB(this.r);
                break;
            }
            case 32: 
            case 83: {
                gradRecord.color = this.decodeRGBA(this.r);
            }
        }
        return gradRecord;
    }

    private Matrix decodeMatrix() throws IOException {
        int n;
        Matrix matrix = new Matrix();
        this.r.syncBits();
        matrix.hasScale = this.r.readBit();
        if (matrix.hasScale) {
            n = this.r.readUBits(5);
            matrix.scaleX = this.r.readSBits(n);
            matrix.scaleY = this.r.readSBits(n);
        }
        matrix.hasRotate = this.r.readBit();
        if (matrix.hasRotate) {
            n = this.r.readUBits(5);
            matrix.rotateSkew0 = this.r.readSBits(n);
            matrix.rotateSkew1 = this.r.readSBits(n);
        }
        n = this.r.readUBits(5);
        matrix.translateX = this.r.readSBits(n);
        matrix.translateY = this.r.readSBits(n);
        return matrix;
    }

    private int decodeRGBA(SwfDecoder swfDecoder) throws IOException {
        int n = swfDecoder.readUI8() << 16;
        n |= swfDecoder.readUI8() << 8;
        n |= swfDecoder.readUI8();
        return n |= swfDecoder.readUI8() << 24;
    }

    private int decodeRGB(SwfDecoder swfDecoder) throws IOException {
        int n = swfDecoder.readUI8() << 16;
        n |= swfDecoder.readUI8() << 8;
        return n |= swfDecoder.readUI8();
    }

    private Shape decodeGlyph(int n, int n2) throws IOException {
        Shape shape = new Shape();
        this.r.syncBits();
        if (n2 > 0) {
            int[] nArray = new int[]{this.r.readUBits(4)};
            int[] nArray2 = new int[]{this.r.readUBits(4)};
            if (n2 > 1) {
                shape.shapeRecords = this.decodeShapeRecords(n, nArray, nArray2);
            }
        }
        return shape;
    }

    private Shape decodeShape(int n) throws IOException {
        Shape shape = new Shape();
        this.r.syncBits();
        int[] nArray = new int[]{this.r.readUBits(4)};
        int[] nArray2 = new int[]{this.r.readUBits(4)};
        shape.shapeRecords = this.decodeShapeRecords(n, nArray, nArray2);
        return shape;
    }

    private List<ShapeRecord> decodeShapeRecords(int n, int[] nArray, int[] nArray2) throws IOException {
        ArrayList<ShapeRecord> arrayList = new ArrayList<ShapeRecord>();
        boolean bl = false;
        do {
            if (this.r.readBit()) {
                if (this.r.readBit()) {
                    arrayList.add(this.decodeStraightEdgeRecord());
                    continue;
                }
                arrayList.add(this.decodeCurvedEdgeRecord());
                continue;
            }
            boolean bl2 = this.r.readBit();
            boolean bl3 = this.r.readBit();
            boolean bl4 = this.r.readBit();
            boolean bl5 = this.r.readBit();
            boolean bl6 = this.r.readBit();
            if (bl2 || bl3 || bl4 || bl5 || bl6) {
                StyleChangeRecord styleChangeRecord = this.decodeStyleChangeRecord(bl2, bl3, bl4, bl5, bl6, n, nArray, nArray2);
                arrayList.add(styleChangeRecord);
                continue;
            }
            bl = true;
        } while (!bl);
        return arrayList;
    }

    private CurvedEdgeRecord decodeCurvedEdgeRecord() throws IOException {
        CurvedEdgeRecord curvedEdgeRecord = new CurvedEdgeRecord();
        int n = 2 + this.r.readUBits(4);
        curvedEdgeRecord.controlDeltaX = this.r.readSBits(n);
        curvedEdgeRecord.controlDeltaY = this.r.readSBits(n);
        curvedEdgeRecord.anchorDeltaX = this.r.readSBits(n);
        curvedEdgeRecord.anchorDeltaY = this.r.readSBits(n);
        return curvedEdgeRecord;
    }

    private StraightEdgeRecord decodeStraightEdgeRecord() throws IOException {
        int n = 2 + this.r.readUBits(4);
        if (this.r.readBit()) {
            int n2 = this.r.readSBits(n);
            int n3 = this.r.readSBits(n);
            return new StraightEdgeRecord(n2, n3);
        }
        if (this.r.readBit()) {
            int n4 = this.r.readSBits(n);
            return new StraightEdgeRecord(0, n4);
        }
        int n5 = this.r.readSBits(n);
        return new StraightEdgeRecord(n5, 0);
    }

    private StyleChangeRecord decodeStyleChangeRecord(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, int[] nArray, int[] nArray2) throws IOException {
        StyleChangeRecord styleChangeRecord = new StyleChangeRecord();
        styleChangeRecord.stateNewStyles = bl;
        styleChangeRecord.stateLineStyle = bl2;
        styleChangeRecord.stateFillStyle1 = bl3;
        styleChangeRecord.stateFillStyle0 = bl4;
        styleChangeRecord.stateMoveTo = bl5;
        if (styleChangeRecord.stateMoveTo) {
            int n2 = this.r.readUBits(5);
            styleChangeRecord.moveDeltaX = this.r.readSBits(n2);
            styleChangeRecord.moveDeltaY = this.r.readSBits(n2);
        }
        if (styleChangeRecord.stateFillStyle0) {
            styleChangeRecord.fillstyle0 = this.r.readUBits(nArray[0]);
        }
        if (styleChangeRecord.stateFillStyle1) {
            styleChangeRecord.fillstyle1 = this.r.readUBits(nArray[0]);
        }
        if (styleChangeRecord.stateLineStyle) {
            styleChangeRecord.linestyle = this.r.readUBits(nArray2[0]);
        }
        if (styleChangeRecord.stateNewStyles) {
            styleChangeRecord.fillstyles = this.decodeFillstyles(n);
            styleChangeRecord.linestyles = this.decodeLinestyles(n);
            this.r.syncBits();
            nArray[0] = this.r.readUBits(4);
            nArray2[0] = this.r.readUBits(4);
        }
        return styleChangeRecord;
    }

    private Tag decodeDefineSprite(int n) throws IOException {
        DefineSprite defineSprite = new DefineSprite();
        defineSprite.header = this.header;
        int n2 = this.r.readUI16();
        defineSprite.framecount = this.r.readUI16();
        this.decodeTags(defineSprite.tagList);
        while (this.r.getOffset() < n) {
            int n3 = this.r.readUI8();
            if (n3 == 0) continue;
            throw new SwfFormatException("nonzero data past end of sprite");
        }
        this.dict.add(n2, defineSprite);
        return defineSprite;
    }

    public Tag decodeSerialNumber() throws IOException {
        int n = this.r.readSI32();
        int n2 = this.r.readSI32();
        byte[] byArray = new byte[2];
        this.r.read(byArray);
        byte by = byArray[0];
        byte by2 = byArray[1];
        long l = this.r.read64();
        long l2 = this.r.read64();
        return new ProductInfo(n, n2, by, by2, l, l2);
    }

    public Header decodeHeader() throws IOException, FatalParseException {
        Header header = new Header();
        byte[] byArray = new byte[8];
        new DataInputStream(this.swfIn).readFully(byArray);
        header.version = byArray[3];
        header.length = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
        if (byArray[0] == 67 && byArray[1] == 87 && byArray[2] == 83) {
            header.compressed = true;
            this.r = new SwfDecoder(new InflaterInputStream(this.swfIn), header.version, 8);
        } else if (byArray[0] == 70 || byArray[1] == 87 || byArray[2] == 83) {
            this.r = new SwfDecoder(this.swfIn, header.version, 8);
        } else {
            this.handler.error("Invalid signature found.  Not a SWF file");
            throw new FatalParseException();
        }
        header.size = this.decodeRect();
        header.rate = this.r.readUI8() << 8 | this.r.readUI8();
        header.framecount = this.r.readUI16();
        return header;
    }

    public Tag decodeFileAttributes() throws IOException {
        FileAttributes fileAttributes = new FileAttributes();
        this.r.syncBits();
        this.r.readUBits(1);
        fileAttributes.useDirectBlit = this.r.readBit();
        fileAttributes.useGPU = this.r.readBit();
        fileAttributes.hasMetadata = this.r.readBit();
        fileAttributes.actionScript3 = this.r.readBit();
        fileAttributes.suppressCrossDomainCaching = this.r.readBit();
        fileAttributes.swfRelativeUrls = this.r.readBit();
        fileAttributes.useNetwork = this.r.readBit();
        this.r.readUBits(24);
        return fileAttributes;
    }

    public Tag decodeEnableTelemetry() throws IOException {
        EnableTelemetry enableTelemetry = new EnableTelemetry();
        this.r.syncBits();
        this.r.readUBits(16);
        enableTelemetry.enabled = true;
        return enableTelemetry;
    }

    public Tag decodeDefineFontAlignZones() throws IOException {
        DefineFontAlignZones defineFontAlignZones = new DefineFontAlignZones();
        int n = this.r.readUI16();
        defineFontAlignZones.font = (DefineFont3)this.dict.getTag(n);
        defineFontAlignZones.font.zones = defineFontAlignZones;
        defineFontAlignZones.csmTableHint = this.r.readUBits(2);
        this.r.readUBits(6);
        defineFontAlignZones.zoneTable = new ZoneRecord[defineFontAlignZones.font.glyphShapeTable.length];
        for (int i = 0; i < defineFontAlignZones.font.glyphShapeTable.length; ++i) {
            ZoneRecord zoneRecord;
            defineFontAlignZones.zoneTable[i] = zoneRecord = new ZoneRecord();
            zoneRecord.numZoneData = this.r.readUI8();
            zoneRecord.zoneData = new long[zoneRecord.numZoneData];
            for (int j = 0; j < zoneRecord.numZoneData; ++j) {
                zoneRecord.zoneData[j] = this.r.readUI32();
            }
            zoneRecord.zoneMask = this.r.readUI8();
        }
        return defineFontAlignZones;
    }

    public Tag decodeCSMTextSettings() throws IOException {
        CSMTextSettings cSMTextSettings = new CSMTextSettings();
        int n = this.r.readUI16();
        if (n != 0) {
            cSMTextSettings.textReference = this.dict.getTag(n);
            if (cSMTextSettings.textReference instanceof DefineText) {
                ((DefineText)cSMTextSettings.textReference).csmTextSettings = cSMTextSettings;
            } else if (cSMTextSettings.textReference instanceof DefineEditText) {
                ((DefineEditText)cSMTextSettings.textReference).csmTextSettings = cSMTextSettings;
            } else {
                this.handler.error("CSMTextSettings' textID must reference a valid DefineText or DefineEditText.  References " + cSMTextSettings.textReference);
            }
        }
        cSMTextSettings.styleFlagsUseSaffron = this.r.readUBits(2);
        cSMTextSettings.gridFitType = this.r.readUBits(3);
        this.r.readUBits(3);
        cSMTextSettings.thickness = this.r.readUBits(32);
        cSMTextSettings.sharpness = this.r.readUBits(32);
        this.r.readUBits(8);
        return cSMTextSettings;
    }

    public Tag decodeDefineFontName() throws IOException {
        DefineFontName defineFontName = new DefineFontName();
        int n = this.r.readUI16();
        defineFontName.font = (DefineFont)this.dict.getTag(n);
        defineFontName.font.license = defineFontName;
        defineFontName.fontName = this.r.readString();
        defineFontName.copyright = this.r.readString();
        return defineFontName;
    }

    private Rect decodeRect() throws IOException {
        this.r.syncBits();
        Rect rect = new Rect();
        int n = this.r.readUBits(5);
        rect.xMin = this.r.readSBits(n);
        rect.xMax = this.r.readSBits(n);
        rect.yMin = this.r.readSBits(n);
        rect.yMax = this.r.readSBits(n);
        return rect;
    }

    public static class FatalParseException
    extends Exception {
        private static final long serialVersionUID = 5819679367367802771L;
    }
}

