/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.clients;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CLIFactory {
    private static final int MIN_VERSION = 660;
    private static final int MAX_VERSION = 670;
    private static Options ascOptions = null;

    private CLIFactory() {
    }

    public static Options getOptionsForASC() {
        if (ascOptions != null) {
            return ascOptions;
        }
        ascOptions = new Options();
        ascOptions.addOption("AS3", false, "use the AS3 class based object model for greater performance and better error reporting");
        ascOptions.addOption("abcfuture", false, "future abc");
        ascOptions.addOption("b", false, "show bytes");
        ascOptions.addOption("coach", false, "warn on common actionscript mistakes (deprecated)");
        ascOptions.addOption("d", false, "emit debug info into the bytecode");
        ascOptions.addOption("doc", false, "emit asdoc info");
        ascOptions.addOption("ES", false, "use the ECMAScript edition 3 prototype based object model to allow dynamic overriding of prototype properties");
        ascOptions.addOption("ES4", false, "use ECMAScript 4 dialect");
        ascOptions.addOption("f", false, "print the flow graph to standard out");
        ascOptions.addOption("h", "help", false, "print this help message");
        ascOptions.addOption("i", false, "write intermediate code to the .il file");
        ascOptions.addOption("l", false, "show line numbers");
        ascOptions.addOption("log", false, "redirect all error output to a logfile");
        ascOptions.addOption("m", false, "write the avm+ assembly code to the .il file");
        ascOptions.addOption("merge", false, "merge the compiled source into a single output file");
        ascOptions.addOption("movieclip", false, "make movieclip");
        ascOptions.addOption("md", false, "emit metadata information into the bytecode");
        ascOptions.addOption("o", "O", false, "produce an optimized abc file");
        ascOptions.addOption("optimize", false, "produce an optimized abc file");
        ascOptions.addOption("p", false, "write parse tree to the .p file");
        ascOptions.addOption("sanity", false, "system-independent error/warning output -- appropriate for sanity testing");
        ascOptions.addOption("static", false, "use static semantics");
        ascOptions.addOption("strict", "!", false, "treat undeclared variable and method access as errors");
        ascOptions.addOption("warnings", false, "warn on common actionscript mistakes");
        ascOptions.addOption("parallel", false, "turn on 'paralle generation of method bodies' feature for Alchemy");
        ascOptions.addOption("inline", false, "turn on the inlining of functions");
        ascOptions.addOption("removedeadcode", false, "remove dead code when -optimize is set");
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"compile program as a specfic version between 660 and 670");
        Option apiOpt = OptionBuilder.create((String)"api");
        ascOptions.addOption(apiOpt);
        OptionBuilder.withArgName((String)"vm version number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"emit bytecode for a target virtual machine version, 1 is AVM1, 2 is AVM2");
        Option avmOpt = OptionBuilder.create((String)"avmtarget");
        ascOptions.addOption(avmOpt);
        OptionBuilder.withArgName((String)"ns::name=value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.withDescription((String)"define a configuration value in the namespace ns");
        Option configOpt = OptionBuilder.create((String)"config");
        ascOptions.addOption(configOpt);
        OptionBuilder.withArgName((String)"avmplus path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"emit an exe file (projector)");
        Option exeOpt = OptionBuilder.create((String)"exe");
        ascOptions.addOption(exeOpt);
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"include the specified source file");
        Option includeOpt = OptionBuilder.create((String)"in");
        ascOptions.addOption(includeOpt);
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"make the packages in the abc file available for import");
        Option importOpt = OptionBuilder.create((String)"import");
        ascOptions.addOption(importOpt);
        OptionBuilder.withArgName((String)"lang");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set the language for output strings {EN|FR|DE|IT|ES|JP|KR|CN|TW}");
        Option langOpt = OptionBuilder.create((String)"language");
        ascOptions.addOption(langOpt);
        OptionBuilder.withArgName((String)"swc file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import a swc library");
        OptionBuilder.withLongOpt((String)"library");
        ascOptions.addOption(OptionBuilder.create((String)"li"));
        OptionBuilder.withArgName((String)"swc file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"import a swc as external library");
        OptionBuilder.withLongOpt((String)"libraryext");
        ascOptions.addOption(OptionBuilder.create((String)"le"));
        OptionBuilder.withArgName((String)"name=value");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"optimizer configuration");
        OptionBuilder.withLongOpt((String)"O2");
        Option o2Opt = OptionBuilder.create((String)"o2");
        ascOptions.addOption(o2Opt);
        OptionBuilder.withArgName((String)"output directory name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Change the directory of the output files");
        Option outdir = OptionBuilder.create((String)"outdir");
        ascOptions.addOption(outdir);
        OptionBuilder.withArgName((String)"basename");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Change the basename of the output file");
        Option out = OptionBuilder.create((String)"out");
        ascOptions.addOption(out);
        OptionBuilder.withArgName((String)"classname,width,height[,fps]");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"emit a SWF file");
        Option swfOpt = OptionBuilder.create((String)"swf");
        ascOptions.addOption(swfOpt);
        OptionBuilder.withArgName((String)"namespace");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"automatically use a namespace when compiling this code");
        Option useOpt = OptionBuilder.create((String)"use");
        ascOptions.addOption(useOpt);
        return ascOptions;
    }

    protected Options getOptionsForMXMLC() {
        return null;
    }

    protected Options getOptionsForCOMPC() {
        return null;
    }
}

