/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.as.codegen;

import org.apache.flex.abc.semantics.Label;
import org.apache.flex.compiler.internal.as.codegen.LabelScopeControlFlowContext;
import org.apache.flex.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.flex.compiler.tree.as.IASNode;

public class LoopControlFlowContext
extends LabelScopeControlFlowContext {
    private Label continueLabel = null;
    private Label breakLabel = null;

    LoopControlFlowContext(IASNode loopContents) {
        super(loopContents);
    }

    @Override
    Label getContinueLabel() {
        if (null == this.continueLabel) {
            this.continueLabel = new Label("#continue#" + Integer.toHexString(this.hashCode()));
        }
        return this.continueLabel;
    }

    boolean hasActiveContinue() {
        return null != this.continueLabel;
    }

    boolean hasActiveBreak() {
        return this.breakLabel != null;
    }

    @Override
    public Label getBreakLabel() {
        if (null == this.breakLabel) {
            this.breakLabel = new Label("#break#" + Integer.toHexString(this.hashCode()));
        }
        return this.breakLabel;
    }

    @Override
    boolean hasDefaultBreakLabel() {
        return true;
    }

    @Override
    boolean hasDefaultContinueLabel() {
        return true;
    }

    @Override
    boolean hasContinueLabel(String label) {
        IASNode loopNode = this.controlFlowTreeNode.getParent();
        assert (loopNode != null);
        IASNode loopNodeParent = loopNode.getParent();
        if (loopNodeParent == null) {
            return false;
        }
        IASNode loopNodeGrandParent = loopNodeParent.getParent();
        if (!(loopNodeGrandParent instanceof LabeledStatementNode)) {
            return false;
        }
        LabeledStatementNode labeledStatementNode = (LabeledStatementNode)loopNodeGrandParent;
        String labeledStatementNodeLabel = labeledStatementNode.getLabel();
        if (labeledStatementNodeLabel == null) {
            return false;
        }
        return labeledStatementNodeLabel.equals(label);
    }
}

