/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom.richtext;

import java.util.Collection;
import org.apache.flex.compiler.fxg.dom.IFXGNode;
import org.apache.flex.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.flex.compiler.internal.fxg.dom.richtext.AbstractRichTextNode;
import org.apache.flex.compiler.internal.fxg.dom.richtext.TextHelper;
import org.apache.flex.compiler.internal.fxg.dom.types.AlignmentBaseline;
import org.apache.flex.compiler.internal.fxg.dom.types.BaselineShift;
import org.apache.flex.compiler.internal.fxg.dom.types.BreakOpportunity;
import org.apache.flex.compiler.internal.fxg.dom.types.ColorWithEnum;
import org.apache.flex.compiler.internal.fxg.dom.types.DigitCase;
import org.apache.flex.compiler.internal.fxg.dom.types.DigitWidth;
import org.apache.flex.compiler.internal.fxg.dom.types.DominantBaseline;
import org.apache.flex.compiler.internal.fxg.dom.types.FontStyle;
import org.apache.flex.compiler.internal.fxg.dom.types.FontWeight;
import org.apache.flex.compiler.internal.fxg.dom.types.Kerning;
import org.apache.flex.compiler.internal.fxg.dom.types.LigatureLevel;
import org.apache.flex.compiler.internal.fxg.dom.types.NumberInherit;
import org.apache.flex.compiler.internal.fxg.dom.types.TextDecoration;
import org.apache.flex.compiler.internal.fxg.dom.types.TextRotation;
import org.apache.flex.compiler.internal.fxg.dom.types.TypographicCase;
import org.apache.flex.compiler.internal.fxg.dom.types.WhiteSpaceCollapse;
import org.apache.flex.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;

public abstract class AbstractRichTextLeafNode
extends AbstractRichTextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    protected static final double BASELINESHIFT_MIN_INCLUSIVE = -1000.0;
    protected static final double BASELINESHIFT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PERCENT_MIN_INCLUSIVE = -1000.0;
    protected static final double LINEHEIGHT_PERCENT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PIXEL_MIN_INCLUSIVE = -720.0;
    protected static final double LINEHEIGHT_PIXEL_MAX_INCLUSIVE = 720.0;
    protected static final double TRACKING_MIN_INCLUSIVE = -1000.0;
    protected static final double TRACKING_MAX_INCLUSIVE = 1000.0;
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize, problems);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = TextHelper.getFontStyle(this, value, this.fontStyle, problems);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = TextHelper.getFontWeight(this, value, this.fontWeight, problems);
        } else if ("kerning".equals(name)) {
            this.kerning = TextHelper.getKerning(this, value, this.kerning, problems);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parseNumberPercentWithSeparateRange(this, value, name, -720.0, 720.0, -1000.0, 1000.0, this.lineHeight, problems);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = TextHelper.getTextDecoration(this, value, this.textDecoration, problems);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name, this.lineThrough, problems);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name, this.color, problems);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha, problems);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = TextHelper.getWhiteSpaceCollapse(this, value, this.whiteSpaceCollapse, problems);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, name, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl(), problems);
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, name, value, this.backgroundColor.getColorWithEnumAsString(), problems);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, name, value, -1000.0, 1000.0, this.baselineShift.getBaselineShiftAsDbl(), problems);
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = TextHelper.getBreakOpportunity(this, value, this.breakOpportunity, problems);
        } else if ("digitCase".equals(name)) {
            this.digitCase = TextHelper.getDigitCase(this, value, this.digitCase, problems);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = TextHelper.getDigitWidth(this, value, this.digitWidth, problems);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = TextHelper.getDominantBaseline(this, value, this.dominantBaseline, problems);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = TextHelper.getAlignmentBaseline(this, value, this.alignmentBaseline, problems);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = TextHelper.getLigatureLevel(this, value, this.ligatureLevel, problems);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = TextHelper.getTypographicCase(this, value, this.typographicCase, problems);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingLeft, problems);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingRight, problems);
        } else if ("textRotation".equals(name)) {
            this.textRotation = TextHelper.getTextRotation(this, value, this.textRotation, problems);
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private BaselineShift getBaselineShift(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return BaselineShift.newInstance(DOMParserHelper.parseNumberPercent(this, value, min, max));
        }
        catch (Exception e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("subscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return BaselineShift.newInstance(defaultValue);
        }
    }

    private NumberInherit getAlphaInherit(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, 0.0, 1.0));
        }
        catch (Exception e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberInherit.newInstance(defaultValue);
        }
    }

    private ColorWithEnum getColorWithEnum(IFXGNode node, String attribute, String value, int defaultValue, Collection<ICompilerProblem> problems) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(DOMParserHelper.parseRGB(this, value, attribute, defaultValue, problems));
    }
}

