/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.util.Preconditions;

public class ConcatRecordReader<T>
implements RecordReader<T> {
    private final Queue<ReaderSupplier<T>> queue;
    private RecordReader<T> current;

    protected ConcatRecordReader(List<ReaderSupplier<T>> readerFactories) {
        readerFactories.forEach(supplier -> {
            ReaderSupplier cfr_ignored_0 = (ReaderSupplier)Preconditions.checkNotNull((Object)supplier, (String)"Reader factory must not be null.");
        });
        this.queue = new LinkedList<ReaderSupplier<T>>(readerFactories);
    }

    public static <R> RecordReader<R> create(List<ReaderSupplier<R>> readers) throws IOException {
        return readers.size() == 1 ? readers.get(0).get() : new ConcatRecordReader(readers);
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<T> readBatch() throws IOException {
        while (true) {
            if (this.current != null) {
                RecordReader.RecordIterator<T> iterator = this.current.readBatch();
                if (iterator != null) {
                    return iterator;
                }
                this.current.close();
                this.current = null;
                continue;
            }
            if (this.queue.size() <= 0) break;
            this.current = this.queue.poll().get();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }

    @FunctionalInterface
    public static interface ReaderSupplier<T> {
        public RecordReader<T> get() throws IOException;
    }
}

