/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.enumerate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.compression.StandardDeCompressors;
import org.apache.flink.connector.file.src.enumerate.DefaultFileFilter;
import org.apache.flink.connector.file.src.enumerate.NonSplittingRecursiveEnumerator;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class BlockSplittingRecursiveEnumerator
extends NonSplittingRecursiveEnumerator {
    private static final Logger LOG = LoggerFactory.getLogger(BlockSplittingRecursiveEnumerator.class);
    private final String[] nonSplittableFileSuffixes;

    public BlockSplittingRecursiveEnumerator() {
        this(new DefaultFileFilter(), StandardDeCompressors.getCommonSuffixes().toArray(new String[0]));
    }

    public BlockSplittingRecursiveEnumerator(Predicate<Path> fileFilter, String[] nonSplittableFileSuffixes) {
        super(fileFilter);
        this.nonSplittableFileSuffixes = Preconditions.checkNotNull(nonSplittableFileSuffixes);
    }

    @Override
    protected void convertToSourceSplits(FileStatus file, FileSystem fs, List<FileSourceSplit> target) throws IOException {
        if (!this.isFileSplittable(file.getPath())) {
            super.convertToSourceSplits(file, fs, target);
            return;
        }
        BlockLocation[] blocks = BlockSplittingRecursiveEnumerator.getBlockLocationsForFile(file, fs);
        if (blocks == null) {
            target.add(new FileSourceSplit(this.getNextId(), file.getPath(), 0L, file.getLen(), file.getModificationTime(), file.getLen()));
        } else {
            for (BlockLocation block : blocks) {
                target.add(new FileSourceSplit(this.getNextId(), file.getPath(), block.getOffset(), block.getLength(), file.getModificationTime(), file.getLen(), block.getHosts()));
            }
        }
    }

    protected boolean isFileSplittable(Path filePath) {
        if (this.nonSplittableFileSuffixes.length == 0) {
            return true;
        }
        String path = filePath.getPath();
        for (String suffix : this.nonSplittableFileSuffixes) {
            if (!path.endsWith(suffix)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static BlockLocation[] getBlockLocationsForFile(FileStatus file, FileSystem fs) throws IOException {
        long len = file.getLen();
        Object[] blocks = fs.getFileBlockLocations(file, 0L, len);
        if (blocks == null || blocks.length == 0) {
            return null;
        }
        long totalLen = 0L;
        for (BlockLocation blockLocation : blocks) {
            totalLen += blockLocation.getLength();
        }
        if (totalLen != len) {
            LOG.warn("Block lengths do not match file length for {}. File length is {}, blocks are {}", new Object[]{file.getPath(), len, Arrays.toString(blocks)});
            return null;
        }
        return blocks;
    }
}

