/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.mailbox;

import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public class Mail {
    private final ThrowingRunnable<? extends Exception> runnable;
    private final int priority;
    private final String descriptionFormat;
    private final Object[] descriptionArgs;
    private final StreamTaskActionExecutor actionExecutor;

    public Mail(ThrowingRunnable<? extends Exception> runnable, int priority, String descriptionFormat, Object ... descriptionArgs) {
        this(runnable, priority, StreamTaskActionExecutor.IMMEDIATE, descriptionFormat, descriptionArgs);
    }

    public Mail(ThrowingRunnable<? extends Exception> runnable, int priority, StreamTaskActionExecutor actionExecutor, String descriptionFormat, Object ... descriptionArgs) {
        this.runnable = Preconditions.checkNotNull(runnable);
        this.priority = priority;
        this.descriptionFormat = descriptionFormat == null ? runnable.toString() : descriptionFormat;
        this.descriptionArgs = Preconditions.checkNotNull(descriptionArgs);
        this.actionExecutor = actionExecutor;
    }

    public int getPriority() {
        return this.priority;
    }

    public void tryCancel(boolean mayInterruptIfRunning) {
        if (this.runnable instanceof Future) {
            ((Future)((Object)this.runnable)).cancel(mayInterruptIfRunning);
        }
    }

    public String toString() {
        return String.format(this.descriptionFormat, this.descriptionArgs);
    }

    public void run() throws Exception {
        this.actionExecutor.runThrowing(this.runnable);
    }
}

