/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.serialization.UnsupportedSerializationVersionException;
import org.apache.geode.internal.serialization.VersionOrdinalImpl;

@Immutable
public class Version
extends VersionOrdinalImpl {
    private final transient String name;
    private final transient String productName;
    private final transient String methodSuffix;
    private final byte majorVersion;
    private final byte minorVersion;
    private final byte release;
    private final byte patch;
    public static final int HIGHEST_VERSION = 116;
    @Immutable
    private static final Version[] VALUES = new Version[117];
    private static final byte TOKEN_ORDINAL = -1;
    private static final int TOKEN_ORDINAL_INT = 255;
    @Immutable
    public static final Version TOKEN = new Version("", "TOKEN", -1, 0, 0, 0, -1);
    private static final short GFE_56_ORDINAL = 0;
    @Immutable
    public static final Version GFE_56 = new Version("GFE", "5.6", 5, 6, 0, 0, 0);
    private static final short GFE_57_ORDINAL = 1;
    @Immutable
    public static final Version GFE_57 = new Version("GFE", "5.7", 5, 7, 0, 0, 1);
    private static final short GFE_58_ORDINAL = 3;
    @Immutable
    public static final Version GFE_58 = new Version("GFE", "5.8", 5, 8, 0, 0, 3);
    private static final short GFE_603_ORDINAL = 4;
    @Immutable
    public static final Version GFE_603 = new Version("GFE", "6.0.3", 6, 0, 3, 0, 4);
    private static final short GFE_61_ORDINAL = 5;
    @Immutable
    public static final Version GFE_61 = new Version("GFE", "6.1", 6, 1, 0, 0, 5);
    private static final short GFE_65_ORDINAL = 6;
    @Immutable
    public static final Version GFE_65 = new Version("GFE", "6.5", 6, 5, 0, 0, 6);
    private static final short GFE_651_ORDINAL = 7;
    @Immutable
    public static final Version GFE_651 = new Version("GFE", "6.5.1", 6, 5, 1, 0, 7);
    private static final short GFE_6516_ORDINAL = 12;
    @Immutable
    public static final Version GFE_6516 = new Version("GFE", "6.5.1.6", 6, 5, 1, 6, 12);
    private static final short GFE_66_ORDINAL = 16;
    @Immutable
    public static final Version GFE_66 = new Version("GFE", "6.6", 6, 6, 0, 0, 16);
    private static final short GFE_662_ORDINAL = 17;
    @Immutable
    public static final Version GFE_662 = new Version("GFE", "6.6.2", 6, 6, 2, 0, 17);
    private static final short GFE_6622_ORDINAL = 18;
    @Immutable
    public static final Version GFE_6622 = new Version("GFE", "6.6.2.2", 6, 6, 2, 2, 18);
    private static final short GFE_70_ORDINAL = 19;
    @Immutable
    public static final Version GFE_70 = new Version("GFE", "7.0", 7, 0, 0, 0, 19);
    private static final short GFE_701_ORDINAL = 20;
    @Immutable
    public static final Version GFE_701 = new Version("GFE", "7.0.1", 7, 0, 1, 0, 20);
    private static final short GFE_7099_ORDINAL = 21;
    @Immutable
    public static final Version GFE_7099 = new Version("GFE", "7.0.99", 7, 0, 99, 0, 21);
    private static final short GFE_71_ORDINAL = 22;
    @Immutable
    public static final Version GFE_71 = new Version("GFE", "7.1", 7, 1, 0, 0, 22);
    private static final short GFE_80_ORDINAL = 30;
    @Immutable
    public static final Version GFE_80 = new Version("GFE", "8.0", 8, 0, 0, 0, 30);
    private static final short GFE_8009_ORDINAL = 31;
    @Immutable
    public static final Version GFE_8009 = new Version("GFE", "8.0.0.9", 8, 0, 0, 9, 31);
    private static final short GFE_81_ORDINAL = 35;
    @Immutable
    public static final Version GFE_81 = new Version("GFE", "8.1", 8, 1, 0, 0, 35);
    private static final short GFE_82_ORDINAL = 40;
    @Immutable
    public static final Version GFE_82 = new Version("GFE", "8.2", 8, 2, 0, 0, 40);
    private static final short GFE_90_ORDINAL = 45;
    @Immutable
    public static final Version GFE_90 = new Version("GFE", "9.0", 9, 0, 0, 0, 45);
    private static final short GEODE_1_1_0_ORDINAL = 50;
    @Immutable
    public static final Version GEODE_1_1_0 = new Version("GEODE", "1.1.0", 1, 1, 0, 0, 50);
    private static final short GEODE_1_1_1_ORDINAL = 55;
    @Immutable
    public static final Version GEODE_1_1_1 = new Version("GEODE", "1.1.1", 1, 1, 1, 0, 55);
    private static final short GEODE_1_2_0_ORDINAL = 65;
    @Immutable
    public static final Version GEODE_1_2_0 = new Version("GEODE", "1.2.0", 1, 2, 0, 0, 65);
    private static final short GEODE_1_3_0_ORDINAL = 70;
    @Immutable
    public static final Version GEODE_1_3_0 = new Version("GEODE", "1.3.0", 1, 3, 0, 0, 70);
    private static final short GEODE_1_4_0_ORDINAL = 75;
    @Immutable
    public static final Version GEODE_1_4_0 = new Version("GEODE", "1.4.0", 1, 4, 0, 0, 75);
    private static final short GEODE_1_5_0_ORDINAL = 80;
    @Immutable
    public static final Version GEODE_1_5_0 = new Version("GEODE", "1.5.0", 1, 5, 0, 0, 80);
    private static final short GEODE_1_6_0_ORDINAL = 85;
    @Immutable
    public static final Version GEODE_1_6_0 = new Version("GEODE", "1.6.0", 1, 6, 0, 0, 85);
    private static final short GEODE_1_7_0_ORDINAL = 90;
    @Immutable
    public static final Version GEODE_1_7_0 = new Version("GEODE", "1.7.0", 1, 7, 0, 0, 90);
    private static final short GEODE_1_8_0_ORDINAL = 95;
    @Immutable
    public static final Version GEODE_1_8_0 = new Version("GEODE", "1.8.0", 1, 8, 0, 0, 95);
    private static final short GEODE_1_9_0_ORDINAL = 100;
    @Immutable
    public static final Version GEODE_1_9_0 = new Version("GEODE", "1.9.0", 1, 9, 0, 0, 100);
    private static final byte GEODE_1_10_0_ORDINAL = 105;
    @Immutable
    public static final Version GEODE_1_10_0 = new Version("GEODE", "1.10.0", 1, 10, 0, 0, 105);
    private static final short GEODE_1_11_0_ORDINAL = 110;
    @Immutable
    public static final Version GEODE_1_11_0 = new Version("GEODE", "1.11.0", 1, 11, 0, 0, 110);
    private static final short GEODE_1_12_0_ORDINAL = 115;
    @Immutable
    public static final Version GEODE_1_12_0 = new Version("GEODE", "1.12.0", 1, 12, 0, 0, 115);
    private static final short GEODE_1_12_1_ORDINAL = 116;
    @Immutable
    public static final Version GEODE_1_12_1;
    @Immutable
    public static final Version CURRENT;
    @Immutable
    public static final short CURRENT_ORDINAL;
    private static final short validOrdinalForTesting = 2;
    @Immutable
    public static final Version TEST_VERSION;

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, short ordinal) {
        super(ordinal);
        this.productName = product;
        this.name = name;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.release = release;
        this.patch = patch;
        this.methodSuffix = this.productName + "_" + this.majorVersion + "_" + this.minorVersion + "_" + this.release + "_" + this.patch;
        if (ordinal != -1) {
            Version.VALUES[this.ordinal] = this;
        }
    }

    public static Version getCurrentVersion() {
        return CURRENT;
    }

    public static Version fromOrdinal(short ordinal) throws UnsupportedSerializationVersionException {
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || VALUES[ordinal] == null) {
            throw new UnsupportedSerializationVersionException(String.format("Peer or client version with ordinal %s not supported. Highest known version is %s", ordinal, Version.CURRENT.name));
        }
        return VALUES[ordinal];
    }

    public static Version fromOrdinalOrCurrent(short ordinal) {
        Version version;
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || (version = VALUES[ordinal]) == null) {
            return CURRENT;
        }
        return version;
    }

    public static void writeOrdinal(DataOutput out, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            out.writeByte(ordinal);
        } else {
            out.writeByte(-1);
            out.writeShort(ordinal);
        }
    }

    public void writeOrdinal(DataOutput out, boolean compressed) throws IOException {
        Version.writeOrdinal(out, this.ordinal, compressed);
    }

    public static void writeOrdinal(ByteBuffer buffer, short ordinal, boolean compressed) {
        if (compressed && ordinal <= 127) {
            buffer.put((byte)ordinal);
        } else {
            buffer.put((byte)-1);
            buffer.putShort(ordinal);
        }
    }

    public static short readOrdinal(DataInput in) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal != -1) {
            return ordinal;
        }
        return in.readShort();
    }

    public static Version readVersion(DataInput in, boolean returnNullForCurrent) throws IOException {
        return Version.fromOrdinalNoThrow(Version.readOrdinal(in), returnNullForCurrent);
    }

    public static Version fromOrdinalNoThrow(short ordinal, boolean returnNullForCurrent) {
        if (ordinal == -1) {
            return TOKEN;
        }
        if (ordinal >= VALUES.length || VALUES[ordinal] == null) {
            return returnNullForCurrent ? null : CURRENT;
        }
        return VALUES[ordinal];
    }

    public static short readOrdinalFromInputStream(InputStream is) throws IOException {
        int ordinal = is.read();
        if (ordinal != -1) {
            int ordinalPart2;
            if (ordinal != 255) {
                return (short)ordinal;
            }
            int ordinalPart1 = is.read();
            if ((ordinalPart1 | (ordinalPart2 = is.read())) >= 0) {
                return (short)(ordinalPart1 << 8 | ordinalPart2);
            }
            return -1;
        }
        return -1;
    }

    public String getMethodSuffix() {
        return this.methodSuffix;
    }

    public String getName() {
        return this.name;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getRelease() {
        return this.release;
    }

    public short getPatch() {
        return this.patch;
    }

    public boolean compatibleWith(Version version) {
        return true;
    }

    @Override
    public String toString() {
        return this.productName + " " + this.name;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.ordinal >> 8), (byte)this.ordinal};
        return bytes;
    }

    public boolean isPre65() {
        return this.compareTo(GFE_65) < 0;
    }

    public static Iterable<? extends Version> getAllVersions() {
        return Arrays.asList(VALUES).stream().filter(x -> x != null && x != TEST_VERSION).collect(Collectors.toList());
    }

    static {
        CURRENT = GEODE_1_12_1 = new Version("GEODE", "1.12.1", 1, 12, 1, 0, 116);
        CURRENT_ORDINAL = CURRENT.ordinal();
        TEST_VERSION = new Version("TEST", "VERSION", 0, 0, 0, 0, 2);
    }
}

