/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class NotificationForwarder
extends NotificationBroadcasterSupport
implements NotificationListener {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final AtomicLong notificationSequenceNumber = new AtomicLong();
    private MBeanServer mBeanServer;

    NotificationForwarder(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        Object notifSource = notification.getSource();
        if ("gemfire.distributedsystem.member.joined".equals(notification.getType())) {
            ObjectName source = (ObjectName)notifSource;
            Object[] noArgs = new String[]{};
            try {
                ObjectName[] stats = (ObjectName[])this.mBeanServer.invoke(source, "manageStats", noArgs, (String[])noArgs);
                if (stats != null) {
                    for (ObjectName stat : stats) {
                        this.mBeanServer.invoke(stat, "getStatistics", noArgs, (String[])noArgs);
                    }
                }
                logger.debug("getStatistics call completed with no exceptions.");
            }
            catch (ReflectionException e) {
                logger.info(String.format("Exception while initializing statistics for: %s", source.toString()), (Throwable)e);
            }
            catch (MBeanException e) {
                logger.info(String.format("Exception while initializing statistics for: %s", source.toString()), (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                logger.info(String.format("Exception while initializing statistics for: %s", source.toString()), (Throwable)e);
            }
            try {
                this.registerNotificationListener(source);
            }
            catch (OperationsException e) {
                logger.info(String.format("Exception while registering notification listener for: %s", source.toString()), (Throwable)e);
            }
        }
        notification = new Notification(notification.getType(), notifSource, notificationSequenceNumber.addAndGet(1L), notification.getTimeStamp(), notification.getMessage());
        this.sendNotification(notification);
    }

    void registerNotificationListener(ObjectName source) throws InstanceNotFoundException {
        this.mBeanServer.addNotificationListener(source, this, null, (Object)source);
    }

    void unregisterNotificationListener(ObjectName source) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mBeanServer.removeNotificationListener(source, this);
    }
}

