/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.annotations.Immutable;

public class ExpirationAction
implements Serializable {
    private static final long serialVersionUID = 658925707882047900L;
    @Immutable
    public static final ExpirationAction INVALIDATE = new ExpirationAction("INVALIDATE");
    @Immutable
    public static final ExpirationAction LOCAL_INVALIDATE = new ExpirationAction("LOCAL_INVALIDATE");
    @Immutable
    public static final ExpirationAction DESTROY = new ExpirationAction("DESTROY");
    @Immutable
    public static final ExpirationAction LOCAL_DESTROY = new ExpirationAction("LOCAL_DESTROY");
    private final transient String name;
    @Immutable
    private static int nextOrdinal = 0;
    public final int ordinal = nextOrdinal++;
    @Immutable
    private static final ExpirationAction[] VALUES = new ExpirationAction[]{INVALIDATE, LOCAL_INVALIDATE, DESTROY, LOCAL_DESTROY};

    private ExpirationAction(String name) {
        this.name = name;
    }

    public boolean isInvalidate() {
        return this == INVALIDATE;
    }

    public boolean isLocalInvalidate() {
        return this == LOCAL_INVALIDATE;
    }

    public boolean isDestroy() {
        return this == DESTROY;
    }

    public boolean isLocalDestroy() {
        return this == LOCAL_DESTROY;
    }

    public boolean isLocal() {
        return this == LOCAL_INVALIDATE || this == LOCAL_DESTROY;
    }

    public boolean isDistributed() {
        return !this.isLocal();
    }

    public String toString() {
        return this.name;
    }

    public String toXmlString() {
        switch (this.name) {
            case "INVALIDATE": {
                return "invalidate";
            }
            case "DESTROY": {
                return "destroy";
            }
            case "LOCAL_DESTROY": {
                return "local-destroy";
            }
            case "LOCAL_INVALIDATE": {
                return "local-invalidate";
            }
        }
        return null;
    }

    public static ExpirationAction fromXmlString(String xmlValue) {
        switch (xmlValue) {
            case "invalidate": {
                return INVALIDATE;
            }
            case "destroy": {
                return DESTROY;
            }
            case "local-destroy": {
                return LOCAL_DESTROY;
            }
            case "local-invalidate": {
                return LOCAL_INVALIDATE;
            }
        }
        throw new IllegalArgumentException("invalid expiration action: " + xmlValue);
    }

    private Object readResolve() throws ObjectStreamException {
        return ExpirationAction.fromOrdinal(this.ordinal);
    }

    public static ExpirationAction fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }
}

