/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class InvalidateOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_VERSION_TAG = 1;

    public static Object execute(ExecutablePool pool, String regionName, EntryEventImpl event, boolean prSingleHopEnabled, LocalRegion region) {
        ClientMetadataService cms;
        ServerLocation server;
        InvalidateOpImpl op = new InvalidateOpImpl(regionName, event, prSingleHopEnabled, region);
        if (prSingleHopEnabled && (server = (cms = region.getCache().getClientMetadataService()).getBucketServerLocation(region, Operation.INVALIDATE, event.getKey(), null, event.getCallbackArgument())) != null) {
            try {
                PoolImpl poolImpl = (PoolImpl)pool;
                boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                op.setAllowDuplicateMetadataRefresh(!onlyUseExistingCnx);
                return pool.executeOn(new ServerLocation(server.getHostName(), server.getPort()), op, true, onlyUseExistingCnx);
            }
            catch (AllConnectionsInUseException poolImpl) {
            }
            catch (ServerConnectivityException e) {
                if (e instanceof ServerOperationException) {
                    throw e;
                }
                cms.removeBucketServerLocation(server);
            }
        }
        return pool.execute(op);
    }

    private InvalidateOp() {
    }

    private static class InvalidateOpImpl
    extends AbstractOp {
        private EntryEventImpl event;
        private boolean prSingleHopEnabled = false;
        private LocalRegion region = null;

        public InvalidateOpImpl(String regionName, EntryEventImpl event, boolean prSingleHopEnabled, LocalRegion region) {
            super(83, event.getCallbackArgument() != null ? 4 : 3);
            Object callbackArg = event.getCallbackArgument();
            this.event = event;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.region = region;
            this.getMessage().addStringPart(regionName, true);
            this.getMessage().addStringOrObjPart(event.getKeyInfo().getKey());
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            Part part;
            byte[] bytesReceived;
            this.processAck(msg, "invalidate");
            boolean isReply = msg.getMessageType() == 6;
            int partIdx = 0;
            int flags = 0;
            if (isReply) {
                if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                    VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    this.event.setVersionTag(tag);
                    if (logger.isDebugEnabled()) {
                        logger.debug("received Invalidate response with {}", (Object)tag);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("received Invalidate response");
                }
            }
            if (this.prSingleHopEnabled && (bytesReceived = (part = msg.getPart(partIdx++)).getSerializedForm())[0] != 0 && bytesReceived.length == 2 && this.region != null) {
                try {
                    ClientMetadataService cms = this.region.getCache().getClientMetadataService();
                    byte myVersion = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.event.getKey(), null, this.event.getCallbackArgument());
                    if (myVersion != bytesReceived[0] || this.isAllowDuplicateMetadataRefresh()) {
                        cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                    }
                }
                catch (CacheClosedException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 84;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startInvalidate();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endInvalidateSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endInvalidate(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

