/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.StartupMessage;
import org.apache.geode.distributed.internal.StartupMessageReplyProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class StartupOperation {
    private static final Logger logger = LogService.getLogger();
    ClusterDistributionManager dm;
    RemoteTransportConfig transport;
    Set newlyDeparted;

    StartupOperation(ClusterDistributionManager dm, RemoteTransportConfig transport) {
        this.dm = dm;
        this.transport = transport;
    }

    boolean sendStartupMessage(Set recipients, Set<InetAddress> interfaces, String redundancyZone, boolean enforceUniqueZone) throws InterruptedException, ReplyException, UnknownHostException, IOException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        StartupMessageReplyProcessor proc = new StartupMessageReplyProcessor((DistributionManager)this.dm, recipients);
        boolean isSharedConfigurationEnabled = false;
        if (InternalLocator.hasLocator()) {
            isSharedConfigurationEnabled = InternalLocator.getLocator().isSharedConfigurationEnabled();
        }
        StartupMessage msg = new StartupMessage(InternalLocator.getLocatorStrings(), isSharedConfigurationEnabled);
        msg.setInterfaces(interfaces);
        msg.setDistributedSystemId(this.dm.getConfig().getDistributedSystemId());
        msg.setRedundancyZone(redundancyZone);
        msg.setEnforceUniqueZone(enforceUniqueZone);
        msg.setMcastEnabled(this.transport.isMcastEnabled());
        msg.setMcastPort(this.dm.getSystem().getOriginalConfig().getMcastPort());
        msg.setMcastHostAddress(this.dm.getSystem().getOriginalConfig().getMcastAddress());
        msg.setTcpDisabled(this.transport.isTcpDisabled());
        msg.setRecipients(recipients);
        msg.setReplyProcessorId(proc.getProcessorId());
        this.newlyDeparted = this.dm.sendOutgoing(msg);
        if (this.newlyDeparted != null && !this.newlyDeparted.isEmpty()) {
            for (InternalDistributedMember id : this.newlyDeparted) {
                this.dm.handleManagerDeparture(id, false, "left the membership view");
                proc.memberDeparted(this.dm, id, true);
            }
        }
        if (proc.stillWaiting() && logger.isDebugEnabled()) {
            logger.debug("Waiting to receive startup responses");
        }
        proc.waitForReplies();
        boolean problems = this.newlyDeparted != null && this.newlyDeparted.size() > 0;
        return !problems;
    }
}

