/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;

public class CopyOnWriteHashSet<T>
implements Set<T>,
Serializable {
    private static final long serialVersionUID = 8591978652141659932L;
    private volatile transient Set<T> snapshot = Collections.emptySet();

    public CopyOnWriteHashSet() {
    }

    public CopyOnWriteHashSet(Set<T> copy) {
        this.snapshot = new HashSet<T>(copy);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<T> iterator;
            private T currentElement;
            {
                this.iterator = new LinkedList(CopyOnWriteHashSet.this.snapshot).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                this.currentElement = this.iterator.next();
                return this.currentElement;
            }

            @Override
            public void remove() {
                CopyOnWriteHashSet.this.snapshot.remove(this.currentElement);
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                this.iterator.forEachRemaining(action);
            }
        };
    }

    @Override
    public int size() {
        return this.snapshot.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T e) {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            HashSet<T> set = new HashSet<T>(this.snapshot);
            boolean result = set.add(e);
            this.snapshot = set;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            HashSet<T> set = new HashSet<T>(this.snapshot);
            boolean result = set.addAll(c);
            this.snapshot = set;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            this.snapshot = Collections.emptySet();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.snapshot.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.snapshot.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.snapshot.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            HashSet<T> set = new HashSet<T>(this.snapshot);
            boolean result = set.remove(o);
            this.snapshot = set;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            HashSet<T> set = new HashSet<T>(this.snapshot);
            boolean result = set.retainAll(c);
            this.snapshot = set;
            return result;
        }
    }

    @Override
    public Object[] toArray() {
        return this.snapshot.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.snapshot.toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return this.snapshot.equals(o);
    }

    @Override
    public int hashCode() {
        return this.snapshot.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        CopyOnWriteHashSet copyOnWriteHashSet = this;
        synchronized (copyOnWriteHashSet) {
            HashSet<T> set = new HashSet<T>(this.snapshot);
            boolean result = set.removeAll(c);
            this.snapshot = set;
            return result;
        }
    }

    public String toString() {
        return this.snapshot.toString();
    }

    public Set<T> getSnapshot() {
        return Collections.unmodifiableSet(this.snapshot);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.snapshot);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.snapshot = (Set)s.readObject();
    }
}

