/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.PartitionedRegionRedundancyTracker;

class BucketRedundancyTracker {
    private boolean noCopiesDecrementOkay = false;
    private boolean lowRedundancyDecrementOkay = false;
    private boolean hasEverHadCopies = false;
    private boolean redundancyEverSatisfied = false;
    private volatile int currentRedundancy = -1;
    private final int targetRedundancy;
    private final PartitionedRegionRedundancyTracker regionRedundancyTracker;

    BucketRedundancyTracker(int redundantCopies, PartitionedRegionRedundancyTracker regionRedundancyTracker) {
        this.targetRedundancy = redundantCopies;
        this.regionRedundancyTracker = regionRedundancyTracker;
    }

    synchronized void closeBucket() {
        this.decrementLowRedundancy();
        this.decrementNoCopies();
    }

    synchronized void updateStatistics(int currentBucketHosts) {
        this.updateRedundancyStatistics(currentBucketHosts);
        this.updateNoCopiesStatistics(currentBucketHosts);
    }

    int getCurrentRedundancy() {
        return this.currentRedundancy;
    }

    private void updateNoCopiesStatistics(int currentBucketHosts) {
        if (currentBucketHosts == 0 && this.hasEverHadCopies) {
            this.incrementNoCopies();
        } else if (currentBucketHosts > 0) {
            this.hasEverHadCopies = true;
            this.decrementNoCopies();
        }
    }

    private void decrementNoCopies() {
        if (this.noCopiesDecrementOkay) {
            this.noCopiesDecrementOkay = false;
            this.regionRedundancyTracker.decrementNoCopiesBucketCount();
        }
    }

    private void incrementNoCopies() {
        if (!this.noCopiesDecrementOkay) {
            this.noCopiesDecrementOkay = true;
            this.regionRedundancyTracker.incrementNoCopiesBucketCount();
        }
    }

    private void updateRedundancyStatistics(int updatedBucketHosts) {
        int updatedRedundancy = updatedBucketHosts - 1;
        this.updateCurrentRedundancy(updatedRedundancy);
        if (updatedRedundancy < this.targetRedundancy) {
            this.reportUpdatedBucketCount(updatedBucketHosts);
            this.incrementLowRedundancy();
        } else if (updatedRedundancy == this.targetRedundancy) {
            this.decrementLowRedundancy();
            this.redundancyEverSatisfied = true;
        }
    }

    private void decrementLowRedundancy() {
        if (this.lowRedundancyDecrementOkay) {
            this.lowRedundancyDecrementOkay = false;
            this.regionRedundancyTracker.decrementLowRedundancyBucketCount();
        }
    }

    private void incrementLowRedundancy() {
        if (!this.lowRedundancyDecrementOkay) {
            this.lowRedundancyDecrementOkay = true;
            this.regionRedundancyTracker.incrementLowRedundancyBucketCount();
        }
    }

    private void updateCurrentRedundancy(int updatedRedundancy) {
        if (updatedRedundancy != this.currentRedundancy) {
            this.regionRedundancyTracker.setActualRedundancy(updatedRedundancy);
            this.currentRedundancy = updatedRedundancy;
        }
    }

    private void reportUpdatedBucketCount(int updatedBucketHosts) {
        if (this.redundancyEverSatisfied) {
            this.regionRedundancyTracker.reportBucketCount(updatedBucketHosts);
        }
    }
}

