/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.geode.internal.cache.backup.BackupInspector;

class WindowsBackupInspector
extends BackupInspector {
    private static final String RESTORE_FILE = "restore.bat";

    WindowsBackupInspector(File backupDir) throws IOException {
        super(backupDir);
    }

    @Override
    public String getCopyFromForOplogFile(String oplogFileName) {
        String line = this.getOplogLineFromFilename(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[1].substring(1, parts[1].length() - 1) + File.separator + parts[3];
    }

    @Override
    public String getCopyToForOplogFile(String oplogFileName) {
        String line = this.getOplogLineFromFilename(oplogFileName);
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        return parts[2].substring(1, parts[2].length() - 1) + File.separator + parts[3];
    }

    @Override
    void parseOplogLines(BufferedReader reader) throws IOException {
        String line;
        while (null != (line = reader.readLine())) {
            if (line.startsWith("IF")) continue;
            if (line.contains("Exit Functions")) break;
            int beginIndex = line.lastIndexOf("\"") + 1;
            int endIndex = line.indexOf("/njh", beginIndex) - 1;
            String oplogName = line.substring(beginIndex, endIndex).trim();
            this.addOplogLine(oplogName, line);
        }
    }

    @Override
    File getRestoreFile(File backupDir) {
        return new File(backupDir, RESTORE_FILE);
    }
}

