/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskLRURegionEntryHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinDiskLRURegionEntryHeapLongKey
extends VMThinDiskLRURegionEntryHeap {
    private static final AtomicLongFieldUpdater<VMThinDiskLRURegionEntryHeapLongKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinDiskLRURegionEntryHeapLongKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    protected DiskId id;
    private final long key;
    private EvictionNode nextEvictionNode;
    private EvictionNode previousEvictionNode;
    private int size;

    public VMThinDiskLRURegionEntryHeapLongKey(RegionEntryContext context, long key, Object value) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        this.key = key;
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        boolean isBackup;
        if (context instanceof InternalRegion) {
            isBackup = ((InternalRegion)context).getDiskRegion().isBackup();
        } else if (context instanceof PlaceHolderDiskRegion) {
            isBackup = true;
        } else {
            throw new IllegalArgumentException("expected a InternalRegion or PlaceHolderDiskRegion");
        }
        if (isBackup) {
            this.diskInitialize(context, value);
        }
    }

    @Override
    public synchronized int updateAsyncEntrySize(EvictionController evictionController) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), null);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    public void setDiskId(RegionEntry oldEntry) {
        this.id = ((DiskEntry)oldEntry).getDiskId();
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore diskRecoveryStore = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, diskStore.needsLinkedList());
        DiskEntry.Helper.initialize(this, diskRecoveryStore, value);
    }

    @Override
    public void setDelayedDiskId(DiskRecoveryStore diskRecoveryStore) {
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, false, diskStore.needsLinkedList());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController) {
        return this.updateEntrySize(evictionController, this.getValue());
    }

    @Override
    public synchronized int updateEntrySize(EvictionController evictionController, Object value) {
        int oldSize = this.getEntrySize();
        int newSize = evictionController.entrySize(this.getKeyForSizing(), value);
        this.setEntrySize(newSize);
        int delta = newSize - oldSize;
        return delta;
    }

    @Override
    public boolean isRecentlyUsed() {
        return this.areAnyBitsSet(0x1000000000000000L);
    }

    @Override
    public void setRecentlyUsed(RegionEntryContext context) {
        if (!this.isRecentlyUsed()) {
            this.setBits(0x1000000000000000L);
            context.incRecentlyUsed();
        }
    }

    @Override
    public void unsetRecentlyUsed() {
        this.clearBits(-1152921504606846977L);
    }

    @Override
    public boolean isEvicted() {
        return this.areAnyBitsSet(0x2000000000000000L);
    }

    @Override
    public void setEvicted() {
        this.setBits(0x2000000000000000L);
    }

    @Override
    public void unsetEvicted() {
        this.clearBits(-2305843009213693953L);
    }

    @Override
    public void setNext(EvictionNode nextEvictionNode) {
        this.nextEvictionNode = nextEvictionNode;
    }

    @Override
    public EvictionNode next() {
        return this.nextEvictionNode;
    }

    @Override
    public void setPrevious(EvictionNode previousEvictionNode) {
        this.previousEvictionNode = previousEvictionNode;
    }

    @Override
    public EvictionNode previous() {
        return this.previousEvictionNode;
    }

    @Override
    public int getEntrySize() {
        return this.size;
    }

    protected void setEntrySize(int size) {
        this.size = size;
    }

    @Override
    public Object getKeyForSizing() {
        return null;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof Long) {
            return (Long)key == this.key;
        }
        return false;
    }
}

