/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.colocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.geode.CancelCriterion;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.colocation.ColocationLogger;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SingleThreadColocationLogger
implements ColocationLogger {
    private static final Logger LOGGER = LogService.getLogger(ColocationLogger.class);
    private final List<String> missingChildren = new ArrayList<String>();
    private final AtomicReference<Future<?>> completed = new AtomicReference();
    private final Object lock = new Object();
    private final PartitionedRegion region;
    private final long delayMillis;
    private final long intervalMillis;
    private final Consumer<String> logger;
    private final Function<PartitionedRegion, Set<String>> allColocationRegionsProvider;
    private final ExecutorService executorService;

    SingleThreadColocationLogger(PartitionedRegion region, long delayMillis, long intervalMillis) {
        this(region, delayMillis, intervalMillis, arg_0 -> ((Logger)LOGGER).warn(arg_0), pr -> ColocationHelper.getAllColocationRegions(pr).keySet(), Executors.newSingleThreadExecutor(runnable -> new LoggingThread("ColocationLogger for " + region.getName(), true, runnable)));
    }

    @VisibleForTesting
    public SingleThreadColocationLogger(PartitionedRegion region, long delayMillis, long intervalMillis, Consumer<String> logger, Function<PartitionedRegion, Set<String>> allColocationRegionsProvider, ExecutorService executorService) {
        this.region = region;
        this.delayMillis = delayMillis;
        this.intervalMillis = intervalMillis;
        this.logger = logger;
        this.allColocationRegionsProvider = allColocationRegionsProvider;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColocationLogger start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completed.get() != null) {
                throw new IllegalStateException(this + " is already running");
            }
            this.completed.set(this.executorService.submit(this.checkForMissingColocatedRegionRunnable()));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.missingChildren.clear();
            this.executorService.shutdownNow();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMissingChildRegion(String childFullPath) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.missingChildren.contains(childFullPath)) {
                this.missingChildren.add(childFullPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMissingChildRegions(PartitionedRegion childRegion) {
        Object object = this.lock;
        synchronized (object) {
            List<String> missingDescendants = childRegion.getMissingColocatedChildren();
            for (String name : missingDescendants) {
                this.addMissingChildRegion(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> updateAndGetMissingChildRegions() {
        Object object = this.lock;
        synchronized (object) {
            Set<String> childRegions = this.allColocationRegionsProvider.apply(this.region);
            this.missingChildren.removeAll(childRegions);
        }
        return new ArrayList<String>(this.missingChildren);
    }

    public String toString() {
        return "ColocationLogger for " + this.region.getName();
    }

    @VisibleForTesting
    Future<?> getFuture() {
        return this.completed.get();
    }

    @VisibleForTesting
    List<String> getMissingChildren() {
        return new ArrayList<String>(this.missingChildren);
    }

    @VisibleForTesting
    ExecutorService getExecutorService() {
        return this.executorService;
    }

    private Runnable checkForMissingColocatedRegionRunnable() {
        return this::checkForMissingColocatedRegion;
    }

    private void checkForMissingColocatedRegion() {
        block4: {
            DistributedSystem.setThreadsSocketPolicy(true);
            SystemFailure.checkFailure();
            CancelCriterion cancelCriterion = this.region.getSystem().getCancelCriterion();
            if (cancelCriterion.isCancelInProgress()) {
                return;
            }
            try {
                this.checkForMissingColocatedRegion(cancelCriterion);
            }
            catch (VirtualMachineError error) {
                SystemFailure.initiateFailure(error);
                throw error;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Unexpected exception in colocation", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMissingColocatedRegion(CancelCriterion cancelCriterion) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            boolean firstLogIteration = true;
            while (true) {
                long waitMillis;
                long l = waitMillis = firstLogIteration ? this.delayMillis : this.intervalMillis;
                if (firstLogIteration) {
                    firstLogIteration = false;
                }
                this.lock.wait(waitMillis);
                PRHARedundancyProvider redundancyProvider = this.region.getRedundancyProvider();
                if (redundancyProvider != null && redundancyProvider.isPersistentRecoveryComplete() || this.missingChildren.isEmpty() || cancelCriterion.isCancelInProgress()) break;
                this.logMissingRegions(this.region.getFullPath());
            }
        }
    }

    private void logMissingRegions(String regionPath) {
        String namesOfMissingChildren = this.missingChildren.isEmpty() ? "" : String.join((CharSequence)(System.lineSeparator() + '\t'), this.missingChildren);
        this.logger.accept(String.format("Persistent data recovery for region %s is prevented by offline colocated %s%s%s", regionPath, this.missingChildren.size() > 1 ? "regions" : "region", System.lineSeparator() + '\t', namesOfMissingChildren));
    }
}

