/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MovePrimariesFPR
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        this.makeFPRPrimaryForThisNode();
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void makeFPRPrimaryForThisNode() {
        partitionedRegion = this.model.getPartitionedRegion();
        FPAs = partitionedRegion.getFixedPartitionAttributesImpl();
        targetId = partitionedRegion.getDistributionManager().getId();
        target = this.model.getMember(targetId);
        for (BucketRollup bucket : this.model.getBuckets()) {
            if (bucket == null) continue;
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                if (!fpa.hasBucket(bucket.getId()) || !fpa.isPrimary() || (source = bucket.getPrimary()) == target) continue;
                if (source == null) ** GOTO lbl-1000
                if (source == PartitionedRegionLoadModel.INVALID_MEMBER) lbl-1000:
                // 2 sources

                {
                    v0 /* !! */  = target;
                } else {
                    v0 /* !! */  = source = source;
                }
                if (MovePrimariesFPR.logger.isDebugEnabled()) {
                    MovePrimariesFPR.logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moving primary from source {} to target {}", (Object)bucket.getId(), (Object)bucket.getPrimary(), (Object)target);
                }
                successfulMove = this.model.movePrimary(new Move(source, target, bucket));
                Assert.assertTrue(successfulMove, " Fixed partitioned region not able to move the primary!");
                if (!successfulMove) continue;
                if (MovePrimariesFPR.logger.isDebugEnabled()) {
                    MovePrimariesFPR.logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moved primary from source {} to target {}", (Object)bucket.getId(), (Object)bucket.getPrimary(), (Object)target);
                }
                bucket.setPrimary(target, bucket.getPrimaryLoad());
            }
        }
    }
}

