/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ObjectPartList;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class GetAllWithCallback
extends BaseCommand {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final GetAllWithCallback singleton = new GetAllWithCallback();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part keysPart = null;
        Part callbackPart = null;
        String regionName = null;
        Object[] keys = null;
        Object callback = null;
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        int partIdx = 0;
        regionNamePart = clientMessage.getPart(partIdx++);
        regionName = regionNamePart.getCachedString();
        keysPart = clientMessage.getPart(partIdx++);
        try {
            keys = (Object[])keysPart.getObject();
        }
        catch (Exception e) {
            GetAllWithCallback.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        callbackPart = clientMessage.getPart(partIdx++);
        try {
            callback = callbackPart.getObject();
        }
        catch (Exception e) {
            GetAllWithCallback.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(serverConnection.getName()).append(": Received getAll request (").append(clientMessage.getPayloadLength()).append(" bytes) from ").append(serverConnection.getSocketString()).append(" for region ").append(regionName).append(" with callback ").append(callback).append(" keys ");
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(keys[i]).append(" ");
                }
            } else {
                buffer.append("NULL");
            }
            logger.debug(buffer.toString());
        }
        if (regionName == null) {
            String message = null;
            message = "The input region name for the getAll request is null";
            logger.warn("{} : {}", new Object[]{serverConnection.getName(), message});
            GetAllWithCallback.writeChunkedErrorResponse(clientMessage, 58, message, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
        if (region == null) {
            String reason = " was not found during getAll request";
            GetAllWithCallback.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
        chunkedResponseMsg.setMessageType(1);
        chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
        chunkedResponseMsg.sendHeader();
        try {
            this.fillAndSendGetAllResponseChunks(region, regionName, keys, serverConnection, callback, securityService);
            serverConnection.setAsTrue(1);
        }
        catch (Exception e) {
            GetAllWithCallback.checkForInterrupt(serverConnection, e);
            GetAllWithCallback.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void fillAndSendGetAllResponseChunks(Region region, String regionName, Object[] keys, ServerConnection servConn, Object callback, SecurityService securityService) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 9[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void sendGetAllResponseChunk(Region region, ObjectPartList list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPartNoCopying(list);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} getAll response chunk for region={}{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)region.getFullPath(), (Object)(logger.isTraceEnabled() ? " values=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""));
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

