/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.SecurityService;

public class UpdateClientNotification
extends BaseCommand {
    @Immutable
    private static final UpdateClientNotification singleton = new UpdateClientNotification();

    public static Command getCommand() {
        return singleton;
    }

    private UpdateClientNotification() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CacheServerStats stats = serverConnection.getCacheServerStats();
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadUpdateClientNotificationRequestTime(start - oldStart);
        oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessUpdateClientNotificationTime(start - oldStart);
    }
}

