/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ArrayUtils {
    public static <T> T getElementAtIndex(T[] array, int index, T defaultValue) {
        try {
            return array[index];
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            return defaultValue;
        }
    }

    public static <T> T getFirst(T ... array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    public static String toString(Object ... array) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        if (array != null) {
            for (Object element : array) {
                buffer.append(count++ > 0 ? ", " : "").append(element);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(String ... array) {
        return ArrayUtils.toString((Object[])array);
    }

    public static Object[] insert(Object[] originalArray, int pos, Object element) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length + 1);
        if (pos > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, pos);
        }
        newArray[pos] = element;
        if (pos < originalArray.length) {
            System.arraycopy(originalArray, pos, newArray, pos + 1, originalArray.length - pos);
        }
        return newArray;
    }

    public static Object[] remove(Object[] originalArray, int pos) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length - 1);
        if (pos > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, pos);
        }
        if (pos < originalArray.length - 1) {
            System.arraycopy(originalArray, pos + 1, newArray, pos, originalArray.length - 1 - pos);
        }
        return newArray;
    }

    public static String objectRefString(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(obj)) : "(null)";
    }

    public static void objectRefString(Object obj, StringBuilder sb) {
        if (obj != null) {
            sb.append(obj.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(obj)));
        } else {
            sb.append("(null)");
        }
    }

    public static String objectString(Object obj) {
        StringBuilder sb = new StringBuilder();
        ArrayUtils.objectString(obj, sb);
        return sb.toString();
    }

    public static void objectString(Object obj, StringBuilder sb) {
        if (obj instanceof Object[]) {
            sb.append('(');
            boolean first = true;
            for (Object o : (Object[])obj) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                ArrayUtils.objectString(o, sb);
            }
            sb.append(')');
        } else {
            ArrayUtils.objectStringWithBytes(obj, sb);
        }
    }

    public static String objectStringNonRecursive(Object obj) {
        StringBuilder sb = new StringBuilder();
        ArrayUtils.objectStringNonRecursive(obj, sb);
        return sb.toString();
    }

    public static boolean areByteArrayArrayEquals(byte[][] v1, byte[][] v2) {
        boolean areEqual = false;
        if (v1.length == v2.length) {
            areEqual = true;
            for (int index = 0; index < v1.length; ++index) {
                if (Arrays.equals(v1[index], v2[index])) continue;
                areEqual = false;
                break;
            }
        }
        return areEqual;
    }

    public static void objectStringNonRecursive(Object obj, StringBuilder sb) {
        if (obj instanceof Object[]) {
            sb.append('(');
            boolean first = true;
            for (Object o : (Object[])obj) {
                if (!first) {
                    sb.append(',');
                    sb.append(o);
                    continue;
                }
                first = false;
                ArrayUtils.objectStringWithBytes(o, sb);
            }
            sb.append(')');
        } else {
            ArrayUtils.objectStringWithBytes(obj, sb);
        }
    }

    private static void objectStringWithBytes(Object obj, StringBuilder sb) {
        if (obj instanceof byte[]) {
            sb.append('(');
            boolean first = true;
            byte[] bytes = (byte[])obj;
            int numBytes = 0;
            for (byte b : bytes) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(b);
                if (numBytes++ < 5000 || numBytes >= bytes.length) continue;
                sb.append(" ...");
                break;
            }
            sb.append(')');
        } else {
            sb.append(obj);
        }
    }

    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static Integer[] toIntegerArray(int[] array) {
        Integer[] integerArray = new Integer[array == null ? 0 : array.length];
        if (array != null) {
            for (int index = 0; index < array.length; ++index) {
                integerArray[index] = array[index];
            }
        }
        return integerArray;
    }

    public static Byte[][] toByteArray(byte[][] array) {
        if (array == null) {
            return null;
        }
        Byte[][] byteArray = new Byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            byteArray[i] = new Byte[array[i].length];
            for (int j = 0; j < array[i].length; ++j) {
                byteArray[i][j] = array[i][j];
            }
        }
        return byteArray;
    }

    public static byte[][] toBytes(Byte[][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        byte[][] array = new byte[byteArray.length][];
        for (int i = 0; i < byteArray.length; ++i) {
            array[i] = new byte[byteArray[i].length];
            for (int j = 0; j < byteArray[i].length; ++j) {
                array[i][j] = byteArray[i][j];
            }
        }
        return array;
    }

    public static <T> List<T> asList(T ... array) {
        return new ArrayList<T>(Arrays.asList(array));
    }
}

