/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.spi;

public enum LogWriterLevel {
    ALL(Integer.MIN_VALUE),
    FINEST(300),
    FINER(400),
    FINE(500),
    CONFIG(700),
    INFO(800),
    WARNING(900),
    ERROR(950),
    SEVERE(1000),
    NONE(Integer.MAX_VALUE);

    private final int intLevel;

    public static LogWriterLevel find(int intLevel) {
        for (LogWriterLevel logWriterLevel : LogWriterLevel.values()) {
            if (logWriterLevel.intLevel != intLevel) continue;
            return logWriterLevel;
        }
        throw new IllegalArgumentException("No LogWriterLevel found for intLevel " + intLevel);
    }

    private LogWriterLevel(int intLevel) {
        this.intLevel = intLevel;
    }

    public int intLevel() {
        return this.intLevel;
    }
}

