/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.File;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreStats;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class DiskStoreMBeanBridge {
    private DiskStoreImpl diskStore;
    private int compactionThreshold;
    private String[] diskDirectories;
    private String name;
    private long timeInterval;
    private int writeBufferSize;
    private long maxOpLogSize;
    private boolean isAutoCompact;
    private boolean isForceCompactionAllowed;
    private int queueSize;
    private MBeanStatsMonitor monitor;
    private StatsRate diskReadsRate;
    private StatsRate diskWritesRate;
    private StatsAverageLatency diskReadsAvgLatency;
    private StatsAverageLatency diskWritesAvgLatency;
    private StatsAverageLatency diskFlushTimeAvgLatency;
    private DiskStoreStats diskStoreStats;
    private DirectoryHolder[] directoryHolders;

    public DiskStoreMBeanBridge(DiskStore ds) {
        this.diskStore = (DiskStoreImpl)ds;
        this.initDiskData();
        this.monitor = new MBeanStatsMonitor("DiskStoreMXBeanMonitor");
        this.diskStoreStats = this.diskStore.getStats();
        this.addDiskStoreStats(this.diskStoreStats);
        this.initializeStats();
    }

    private void initDiskData() {
        this.name = this.diskStore.getName();
        this.compactionThreshold = this.diskStore.getCompactionThreshold();
        this.timeInterval = this.diskStore.getTimeInterval();
        this.writeBufferSize = this.diskStore.getWriteBufferSize();
        this.maxOpLogSize = this.diskStore.getMaxOplogSize();
        this.queueSize = this.diskStore.getQueueSize();
        this.isAutoCompact = this.diskStore.getAutoCompact();
        this.isForceCompactionAllowed = this.diskStore.getAllowForceCompaction();
        this.directoryHolders = this.diskStore.getDirectoryHolders();
        File[] diskDirs = this.diskStore.getDiskDirs();
        String[] diskDirStr = new String[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            diskDirStr[i] = diskDirs[i].getAbsolutePath();
        }
        this.diskDirectories = diskDirStr;
    }

    public void stopMonitor() {
        this.monitor.stopListener();
    }

    public boolean forceCompaction() {
        return this.diskStore.forceCompaction();
    }

    public void forceRoll() {
        this.diskStore.forceRoll();
    }

    public void flush() {
        this.diskStore.flush();
    }

    public int getCompactionThreshold() {
        return this.compactionThreshold;
    }

    public String[] getDiskDirectories() {
        return this.diskDirectories;
    }

    public long getMaxOpLogSize() {
        return this.maxOpLogSize;
    }

    public String getName() {
        return this.name;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public boolean isAutoCompact() {
        return this.isAutoCompact;
    }

    public boolean isForceCompactionAllowed() {
        return this.isForceCompactionAllowed;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public DiskStoreMBeanBridge() {
        this.monitor = new MBeanStatsMonitor("DiskStoreMXBeanMonitor");
        this.initializeStats();
    }

    public void addDiskStoreStats(DiskStoreStats stats) {
        this.monitor.addStatisticsToMonitor(stats.getStats());
    }

    private void initializeStats() {
        String[] diskReads = new String[]{"readBytes", "recoveredBytes"};
        this.diskReadsRate = new StatsRate(diskReads, StatType.LONG_TYPE, this.monitor);
        this.diskWritesRate = new StatsRate("writtenBytes", StatType.LONG_TYPE, this.monitor);
        this.diskFlushTimeAvgLatency = new StatsAverageLatency("flushes", StatType.LONG_TYPE, "flushTime", this.monitor);
        this.diskReadsAvgLatency = new StatsAverageLatency("readBytes", StatType.LONG_TYPE, "readTime", this.monitor);
        this.diskWritesAvgLatency = new StatsAverageLatency("writtenBytes", StatType.LONG_TYPE, "writeTime", this.monitor);
    }

    public long getDiskReadsAvgLatency() {
        return this.diskReadsAvgLatency.getAverageLatency();
    }

    public float getDiskReadsRate() {
        return this.diskReadsRate.getRate();
    }

    public long getDiskWritesAvgLatency() {
        return this.diskWritesAvgLatency.getAverageLatency();
    }

    public float getDiskWritesRate() {
        return this.diskWritesRate.getRate();
    }

    public long getFlushTimeAvgLatency() {
        return this.diskFlushTimeAvgLatency.getAverageLatency();
    }

    public int getTotalBackupInProgress() {
        return this.getDiskStoreStatistic("backupsInProgress").intValue();
    }

    public int getTotalBackupCompleted() {
        return this.getDiskStoreStatistic("backupsCompleted").intValue();
    }

    public long getTotalBytesOnDisk() {
        return this.diskStore.getTotalBytesOnDisk();
    }

    public int getTotalQueueSize() {
        return this.getDiskStoreStatistic("queueSize").intValue();
    }

    public int getTotalRecoveriesInProgress() {
        return this.getDiskStoreStatistic("recoveriesInProgress").intValue();
    }

    public Number getDiskStoreStatistic(String statName) {
        if (this.diskStoreStats != null) {
            return this.diskStoreStats.getStats().get(statName);
        }
        return 0;
    }

    public float getDiskUsageWarningPercentage() {
        return this.diskStore.getDiskUsageWarningPercentage();
    }

    public float getDiskUsageCriticalPercentage() {
        return this.diskStore.getDiskUsageCriticalPercentage();
    }

    public void setDiskUsageWarningPercentage(float warningPercent) {
        this.diskStore.setDiskUsageWarningPercentage(warningPercent);
    }

    public void setDiskUsageCriticalPercentage(float criticalPercent) {
        this.diskStore.setDiskUsageCriticalPercentage(criticalPercent);
    }

    public float getDiskUsagePercentage() {
        return this.diskStore.getDiskUsagePercentage();
    }

    public float getDiskFreePercentage() {
        return this.diskStore.getDiskFreePercentage();
    }
}

