/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class ServerBridge {
    protected MBeanStatsMonitor monitor;
    protected StatsRate getRequestRate;
    protected StatsRate putRequestRate;
    protected StatsAverageLatency getRequestAvgLatency;
    protected StatsAverageLatency putRequestAvgLatency;
    protected Acceptor acceptor;

    public ServerBridge(CacheServer cacheServer) {
        this((CacheServerImpl)cacheServer, new MBeanStatsMonitor("ServerMXBeanMonitor"));
    }

    public ServerBridge(CacheServerImpl cacheServer, MBeanStatsMonitor monitor) {
        this(cacheServer.getAcceptor(), monitor);
    }

    public ServerBridge(Acceptor acceptor, MBeanStatsMonitor monitor) {
        this.monitor = monitor;
        this.acceptor = acceptor;
        this.initializeStats();
        this.startMonitor();
    }

    public void addCacheServerStats(CacheServerStats cacheServerStats) {
        this.monitor.addStatisticsToMonitor(cacheServerStats.getStats());
    }

    protected void addServer(CacheServer cacheServer) {
        this.acceptor = ((CacheServerImpl)cacheServer).getAcceptor();
        this.startMonitor();
    }

    protected void removeServer() {
        this.acceptor = null;
        this.stopMonitor();
    }

    private void startMonitor() {
        CacheServerStats stats = this.acceptor.getStats();
        this.addCacheServerStats(stats);
    }

    public void stopMonitor() {
        this.monitor.removeStatisticsFromMonitor(null);
        this.monitor.stopListener();
    }

    private void initializeStats() {
        this.getRequestRate = new StatsRate("getRequests", StatType.INT_TYPE, this.monitor);
        this.putRequestRate = new StatsRate("putRequests", StatType.INT_TYPE, this.monitor);
        this.getRequestAvgLatency = new StatsAverageLatency("getRequests", StatType.INT_TYPE, "processGetTime", this.monitor);
        this.putRequestAvgLatency = new StatsAverageLatency("putRequests", StatType.INT_TYPE, "processPutTime", this.monitor);
    }

    public ServerBridge() {
        this.monitor = new MBeanStatsMonitor("ServerMXBeanMonitor");
        this.initializeStats();
    }

    public double getConnectionLoad() {
        return this.getStatistic("connectionLoad").intValue();
    }

    public int getConnectionThreads() {
        return this.getStatistic("connectionThreads").intValue();
    }

    public long getGetRequestAvgLatency() {
        return this.getRequestAvgLatency.getAverageLatency();
    }

    public float getGetRequestRate() {
        return this.getRequestRate.getRate();
    }

    public long getPutRequestAvgLatency() {
        return this.putRequestAvgLatency.getAverageLatency();
    }

    public float getPutRequestRate() {
        return this.putRequestRate.getRate();
    }

    public double getLoadPerConnection() {
        return this.getStatistic("loadPerConnection").intValue();
    }

    public double getLoadPerQueue() {
        return this.getStatistic("loadPerQueue").intValue();
    }

    public double getQueueLoad() {
        return this.getStatistic("queueLoad").doubleValue();
    }

    public int getThreadQueueSize() {
        return this.getStatistic("threadQueueSize").intValue();
    }

    public int getTotalConnectionsTimedOut() {
        return this.getStatistic("connectionsTimedOut").intValue();
    }

    public int getTotalFailedConnectionAttempts() {
        return this.getStatistic("failedConnectionAttempts").intValue();
    }

    public long getTotalSentBytes() {
        return this.getStatistic("sentBytes").longValue();
    }

    public long getTotalReceivedBytes() {
        return this.getStatistic("receivedBytes").longValue();
    }

    public int getClientConnectionCount() {
        return this.getStatistic("currentClientConnections").intValue();
    }

    public int getCurrentClients() {
        return this.getStatistic("currentClients").intValue();
    }

    protected Number getStatistic(String statName) {
        if (this.monitor != null) {
            return this.monitor.getStatistic(statName);
        }
        return 0;
    }
}

