/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.ManagementAgent;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class DownloadJarFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext<Object[]> context) {
        InternalConfigurationPersistenceService sharedConfig;
        InternalLocator locator = this.getLocator();
        Object[] args = context.getArguments();
        String group = (String)args[0];
        String jarName = (String)args[1];
        RemoteInputStream result = null;
        if (locator != null && group != null && jarName != null && (sharedConfig = locator.getConfigurationPersistenceService()) != null) {
            SystemManagementService managementService = this.getExistingManagementService(context);
            ManagementAgent managementAgent = managementService.getManagementAgent();
            if (managementAgent == null) {
                throw new IllegalStateException("Failed to download jar because JMX Management agent is not available. Please ensure geode property jmx-manager is set to true.");
            }
            try (SimpleRemoteInputStream istream = null;){
                File jarFile = sharedConfig.getPathToJarOnThisLocator(group, jarName).toFile();
                RemoteStreamExporter exporter = managementAgent.getRemoteStreamExporter();
                istream = new SimpleRemoteInputStream((InputStream)new BufferedInputStream(new FileInputStream(jarFile)));
                result = (RemoteInputStream)exporter.export((RemoteStreamServer)istream);
                istream = null;
            }
        }
        context.getResultSender().lastResult(result);
    }

    InternalLocator getLocator() {
        return (InternalLocator)Locator.getLocator();
    }

    SystemManagementService getExistingManagementService(FunctionContext<Object[]> context) {
        return (SystemManagementService)SystemManagementService.getExistingManagementService(context.getCache());
    }

    @Override
    public String getId() {
        return DownloadJarFunction.class.getName();
    }
}

