/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.sink;

import java.util.List;
import java.util.Map;
import org.apache.geode.kafka.GeodeConnectorConfig;
import org.apache.geode.kafka.utils.EnumRecommender;
import org.apache.geode.kafka.utils.EnumValidator;
import org.apache.geode.kafka.utils.GeodeSinkConfigurationConstants;
import org.apache.kafka.common.config.ConfigDef;

public class GeodeSinkConnectorConfig
extends GeodeConnectorConfig {
    public static final ConfigDef SINK_CONFIG_DEF = GeodeSinkConnectorConfig.configurables();
    private final Map<String, List<String>> topicToRegions = GeodeSinkConnectorConfig.parseTopicToRegions(this.getString("topic-to-regions"));
    private final GeodeSinkConfigurationConstants.NullValueBehavior nullValueBehavior = GeodeSinkConfigurationConstants.NullValueBehavior.valueOf(this.getString("null-values-behavior").toUpperCase());

    public GeodeSinkConnectorConfig(Map<String, String> connectorProperties) {
        super(SINK_CONFIG_DEF, connectorProperties);
    }

    protected static ConfigDef configurables() {
        ConfigDef configDef = GeodeConnectorConfig.configurables();
        configDef.define("topic-to-regions", ConfigDef.Type.STRING, (Object)"[gkcTopic:gkcRegion]", ConfigDef.Importance.HIGH, "A comma separated list of \"one topic to many regions\" bindings.  Each binding is surrounded by brackets. For example \"[topicName:regionName], [anotherTopic: regionName, anotherRegion]", "Sink-Configurations", 1, ConfigDef.Width.MEDIUM, "Topic to region mapping");
        configDef.define("null-values-behavior", ConfigDef.Type.STRING, (Object)"remove", (ConfigDef.Validator)EnumValidator.in(GeodeSinkConfigurationConstants.NullValueBehavior.values()), ConfigDef.Importance.MEDIUM, "If set to REMOVE, when topics send a SinkRecord with a null value, we will convert to an operation similar to region.remove instead of putting a null value into the region", "Sink-Configurations", 2, ConfigDef.Width.MEDIUM, "Null values behavior", (ConfigDef.Recommender)EnumRecommender.in(GeodeSinkConfigurationConstants.NullValueBehavior.values()));
        return configDef;
    }

    public Map<String, List<String>> getTopicToRegions() {
        return this.topicToRegions;
    }

    public boolean getNullValueBehavior() {
        return this.nullValueBehavior.equals((Object)GeodeSinkConfigurationConstants.NullValueBehavior.REMOVE);
    }
}

