/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import java.io.IOException;
import java.io.InputStream;
import org.apache.guacamole.GuacamoleClientOverrunException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.rest.APIException;

public class LimitedRequestInputStream
extends InputStream {
    private final InputStream stream;
    private final long maxLength;
    private long bytesRead = 0L;

    public LimitedRequestInputStream(InputStream stream, long maxLength) {
        this.stream = stream;
        this.maxLength = maxLength;
    }

    private synchronized void recheckLength() throws APIException {
        if (this.bytesRead > this.maxLength) {
            throw new APIException((GuacamoleException)new GuacamoleClientOverrunException("Request body/entity too large."));
        }
    }

    private synchronized long limitedRead(long change) throws APIException {
        if (change != -1L) {
            this.bytesRead += change;
            this.recheckLength();
        }
        return change;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public long skip(long l) throws IOException {
        this.recheckLength();
        return this.limitedRead(this.stream.skip(l));
    }

    @Override
    public int read(byte[] bytes, int i, int i1) throws IOException {
        this.recheckLength();
        return (int)this.limitedRead((long)this.stream.read(bytes, i, i1));
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        this.recheckLength();
        return (int)this.limitedRead((long)this.stream.read(bytes));
    }

    @Override
    public int read() throws IOException {
        this.recheckLength();
        int value = this.stream.read();
        if (value != -1) {
            this.limitedRead(1L);
        }
        return value;
    }
}

