/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSet;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.InitialPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ChangeStreamDao {
    private final @UnknownKeyFor @NonNull @Initialized String changeStreamName;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority;
    private final @UnknownKeyFor @NonNull @Initialized String jobName;
    private final @UnknownKeyFor @NonNull @Initialized Dialect dialect;

    ChangeStreamDao(@UnknownKeyFor @NonNull @Initialized String changeStreamName, @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority, @UnknownKeyFor @NonNull @Initialized String jobName, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        this.changeStreamName = changeStreamName;
        this.databaseClient = databaseClient;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
        this.dialect = dialect;
    }

    public @UnknownKeyFor @NonNull @Initialized ChangeStreamResultSet changeStreamQuery(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp startTimestamp, @UnknownKeyFor @NonNull @Initialized Timestamp endTimestamp, @UnknownKeyFor @NonNull @Initialized long heartbeatMillis) {
        Statement statement;
        String partitionTokenOrNull = InitialPartition.isInitialPartition(partitionToken) ? null : partitionToken;
        String query = "";
        if (this.isPostgres()) {
            query = "SELECT * FROM \"spanner\".\"read_json_" + this.changeStreamName + "\"($1, $2, $3, $4, null)";
            statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("p1").to(startTimestamp)).bind("p2").to(endTimestamp)).bind("p3").to(partitionTokenOrNull)).bind("p4").to(heartbeatMillis)).build();
        } else {
            query = "SELECT * FROM READ_" + this.changeStreamName + "(   start_timestamp => @startTimestamp,   end_timestamp => @endTimestamp,   partition_token => @partitionToken,   read_options => null,   heartbeat_milliseconds => @heartbeatMillis)";
            statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)query).bind("startTimestamp").to(startTimestamp)).bind("endTimestamp").to(endTimestamp)).bind("partitionToken").to(partitionTokenOrNull)).bind("heartbeatMillis").to(heartbeatMillis)).build();
        }
        ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[]{Options.priority((Options.RpcPriority)this.rpcPriority), Options.tag((String)("job=" + this.jobName))});
        return new ChangeStreamResultSet(resultSet);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPostgres() {
        return this.dialect == Dialect.POSTGRESQL;
    }
}

