/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.DelegateCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class StringDelegateCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized DelegateCoder<T, @UnknownKeyFor @NonNull @Initialized String> delegateCoder;
    private final @UnknownKeyFor @NonNull @Initialized Class<T> clazz;

    public static <T> @UnknownKeyFor @NonNull @Initialized StringDelegateCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return StringDelegateCoder.of(clazz, TypeDescriptor.of(clazz));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized StringDelegateCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return new StringDelegateCoder<T>(clazz, typeDescriptor);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "StringDelegateCoder(" + this.clazz + ")";
    }

    protected StringDelegateCoder(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        this.delegateCoder = DelegateCoder.of(StringUtf8Coder.of(), obj -> String.valueOf(obj), serialized -> clazz.getConstructor(String.class).newInstance(serialized), typeDescriptor);
        this.clazz = clazz;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringDelegateCoder that = (StringDelegateCoder)o;
        return this.clazz.equals(that.clazz);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream,  @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.delegateCoder.encode(value, outStream, context);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream,  @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.delegateCoder.decode(inStream, context);
    }

    @Override
    public void verifyDeterministic() throws  @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.delegateCoder.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(T value) {
        return this.delegateCoder.structuralValue(value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.delegateCoder.getEncodedTypeDescriptor();
    }
}

