/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.ConnectionListener;
import com.ibm.as400.access.CredentialVault;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.SignonInfo;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.ietf.jgss.GSSCredential;

class AS400ImplProxy
extends AbstractProxyImpl
implements AS400Impl {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400ImplProxy";
    private int bidiStringType = 0;

    AS400ImplProxy() {
        super("AS400");
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connection_.addListener(this.pxId_, listener, "Connection");
    }

    @Override
    public String ccsidToEncoding(int ccsid) {
        try {
            return (String)this.connection_.callMethod(this.pxId_, "ccsidToEncoding", new Class[]{Integer.TYPE}, new Object[]{ccsid}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public SignonInfo changePassword(String systemName, boolean systemNameLocal, String userId, byte[] oldBytes, byte[] newBytes) throws AS400SecurityException, IOException {
        return this.changePassword(systemName, systemNameLocal, userId, oldBytes, newBytes, null);
    }

    @Override
    public SignonInfo changePassword(String systemName, boolean systemNameLocal, String userId, byte[] oldBytes, byte[] newBytes, char[] additionalAuthenticationFactor) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "changePassword", new Class[]{String.class, Boolean.TYPE, String.class, byte[].class, byte[].class}, new Object[]{systemName, systemNameLocal, userId, oldBytes, newBytes}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public void connect(int service) throws AS400SecurityException, IOException {
        this.connect(service, -1, false);
    }

    @Override
    public void connect(int service, int overridePort, boolean skipSignonServer) throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connect", new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{service, overridePort, skipSignonServer});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public void disconnect(int service) {
        try {
            this.connection_.callMethod(this.pxId_, "disconnect", new Class[]{Integer.TYPE}, new Object[]{service});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public byte[] exchangeSeed(byte[] proxySeed) {
        try {
            return (byte[])this.connection_.callMethod(this.pxId_, "exchangeSeed", new Class[]{byte[].class}, new Object[]{proxySeed}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void generateProfileToken(ProfileTokenCredential profileToken, String userIdentity) throws AS400SecurityException, IOException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "generateProfileToken", new Class[]{ProfileTokenCredential.class, String.class}, new Object[]{profileToken, userIdentity}, new boolean[]{true, false}, true);
            ProfileTokenCredential returnArg = (ProfileTokenCredential)rv.getArgument(0);
            profileToken.setToken(returnArg.getToken());
            return;
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    @Override
    public void generateProfileToken(ProfileTokenCredential profileToken, String userId, CredentialVault vault, char[] additionalAuthFactor, String gssName) throws AS400SecurityException, IOException, InterruptedException {
        try {
            ProxyReturnValue rv = this.connection_.callMethod(this.pxId_, "generateProfileToken", new Class[]{ProfileTokenCredential.class, String.class, CredentialVault.class, char[].class, String.class}, new Object[]{profileToken, userId, vault, additionalAuthFactor, gssName}, new boolean[]{true, false, false, false, false}, true);
            ProfileTokenCredential returnArg = (ProfileTokenCredential)rv.getArgument(0);
            profileToken.setToken(returnArg.getToken());
            return;
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow3(e);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    @Override
    public String[] getJobs(int service) {
        try {
            return (String[])this.connection_.callMethod(this.pxId_, "getJobs", new Class[]{Integer.TYPE}, new Object[]{service}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public int getServicePort(String systemName, int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "getServicePort", new Class[]{String.class, Integer.TYPE}, new Object[]{systemName, service}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean isConnected(int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "isConnected", new Class[]{Integer.TYPE}, new Object[]{service}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean isConnectionAlive() {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, "isConnectionAlive");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public boolean isConnectionAlive(int service) {
        try {
            return this.connection_.callMethod(this.pxId_, "isConnectionAlive", new Class[]{Integer.TYPE}, new Object[]{service}).getReturnValueBoolean();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void newConverter(int ccsid) throws UnsupportedEncodingException {
        try {
            this.connection_.callMethod(this.pxId_, "newConverter", new Class[]{Integer.TYPE}, new Object[]{ccsid});
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof UnsupportedEncodingException) {
                throw (UnsupportedEncodingException)target;
            }
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        this.connection_.removeListener(this.pxId_, listener, "Connection");
    }

    @Override
    public void setGSSCredential(GSSCredential gssCredential) {
        try {
            this.connection_.callMethod(this.pxId_, "setGSSCredential", new Class[]{Object.class}, new Object[]{gssCredential});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setServicePort(String systemName, int service, int port) {
        try {
            this.connection_.callMethod(this.pxId_, "setServicePort", new Class[]{String.class, Integer.TYPE, Integer.TYPE}, new Object[]{systemName, service, port});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setServicePortsToDefault(String systemName) {
        try {
            this.connection_.callMethod(this.pxId_, "setServicePortsToDefault", new Class[]{String.class}, new Object[]{systemName});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setState(SSLOptions useSSLConnection, boolean canUseNativeOptimization, boolean threadUsed, int ccsid, String nlv, SocketProperties socketProperties, String ddmRDB, boolean mustUseNetSockets, boolean mustUseSuppliedProfile, boolean mustAddLanguageLibrary) {
        try {
            this.connection_.callMethod(this.pxId_, "setState", new Class[]{SSLOptions.class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, String.class, SocketProperties.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{useSSLConnection, canUseNativeOptimization, threadUsed, ccsid, nlv, socketProperties, ddmRDB, mustUseNetSockets, mustUseSuppliedProfile, mustAddLanguageLibrary});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public SignonInfo setState(AS400Impl impl, CredentialVault credVault) {
        return null;
    }

    @Override
    public SignonInfo signon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        return this.signon(systemName, systemNameLocal, userId, vault, gssName, null);
    }

    @Override
    public SignonInfo signon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName, char[] additionalAuthenticationFactor) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "signon", new Class[]{String.class, Boolean.TYPE, String.class, CredentialVault.class, String.class}, new Object[]{systemName, systemNameLocal, userId, vault, gssName}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public SignonInfo skipSignon(String systemName, boolean systemNameLocal, String userId, CredentialVault vault, String gssName) throws AS400SecurityException, IOException {
        try {
            return (SignonInfo)this.connection_.callMethod(this.pxId_, "skipSignon", new Class[]{String.class, Boolean.TYPE, String.class, CredentialVault.class, String.class}, new Object[]{systemName, systemNameLocal, userId, vault, gssName}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow2(e);
        }
    }

    @Override
    public void setBidiStringType(int bidiStringType) {
        this.bidiStringType = bidiStringType;
    }

    @Override
    public int getBidiStringType() {
        return this.bidiStringType;
    }

    @Override
    public String getSystemName() {
        return this.connection_.getSystemName();
    }

    @Override
    public void setVRM(int v, int r, int m) {
    }

    @Override
    public void setAdditionalAuthenticationFactor(char[] additionalAuthFactor) {
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

