/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VIFSDirectory;
import com.ibm.as400.vaccess.VIFSFile;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

class IFSFileCreateAction
implements VAction,
CellEditorListener {
    private static final String newName_ = ResourceLoader.getText("IFS_NEW_FILE");
    private static final String text_ = ResourceLoader.getText("ACTION_FILE_CREATE");
    private boolean enabled_ = true;
    private IFSFile file_ = null;
    private IFSFile newFile_ = null;
    private VIFSFile newObject_ = null;
    private VIFSDirectory object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSFileCreateAction(VIFSDirectory object, IFSFile file) {
        this.file_ = file;
        this.object_ = object;
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public void editingCanceled(ChangeEvent event) {
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        CellEditor editor = (CellEditor)event.getSource();
        editor.removeCellEditorListener(this);
        String newName = editor.getCellEditorValue().toString();
        try {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Renaming new file [" + this.newFile_.getName() + "] to [" + newName + "].");
            }
            this.newFile_.renameTo(new IFSFile(this.newFile_.getSystem(), this.newFile_.getParent(), newName));
            this.objectEventSupport_.fireObjectChanged(this.newObject_);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
    }

    @Override
    public String getText() {
        return text_;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(VActionContext context) {
        IFSFileOutputStream outputStream = null;
        try {
            int count = 1;
            boolean success = false;
            AS400 system = this.file_.getSystem();
            this.newFile_ = new IFSFile(system, this.file_, newName_);
            while (this.newFile_.exists()) {
                this.newFile_ = new IFSFile(system, this.file_, newName_ + " (" + ++count + ")");
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Creating file [" + this.newFile_.getName() + "].");
            }
            outputStream = new IFSFileOutputStream(system, this.newFile_, -1, false);
            this.newObject_ = new VIFSFile(this.newFile_);
            this.objectEventSupport_.fireObjectCreated(this.newObject_, this.object_);
            CellEditor editor = context.startEditing(this.newObject_, VIFSDirectory.NAME_PROPERTY);
            if (editor != null) {
                editor.addCellEditorListener(this);
            }
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable e) {
                    Trace.log(2, e);
                }
            }
        }
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public String toString() {
        return this.getText();
    }
}

