/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortedRanges
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(SortedRanges.class);
    private TreeSet<Range> ranges = new TreeSet();
    private long indicesCount;

    SortedRanges() {
    }

    synchronized SkipRangeIterator skipRangeIterator() {
        return new SkipRangeIterator(this.ranges.iterator());
    }

    synchronized long getIndicesCount() {
        return this.indicesCount;
    }

    synchronized SortedSet<Range> getRanges() {
        return this.ranges;
    }

    synchronized void add(Range range) {
        if (range.isEmpty()) {
            return;
        }
        long startIndex = range.getStartIndex();
        long endIndex = range.getEndIndex();
        SortedSet<Range> headSet = this.ranges.headSet(range);
        if (headSet.size() > 0) {
            Range previousRange = headSet.last();
            LOG.debug("previousRange " + previousRange);
            if (startIndex < previousRange.getEndIndex()) {
                if (this.ranges.remove(previousRange)) {
                    this.indicesCount -= previousRange.getLength();
                }
                startIndex = previousRange.getStartIndex();
                endIndex = endIndex >= previousRange.getEndIndex() ? endIndex : previousRange.getEndIndex();
            }
        }
        Iterator tailSetIt = this.ranges.tailSet(range).iterator();
        while (tailSetIt.hasNext()) {
            Range nextRange = (Range)tailSetIt.next();
            LOG.debug("nextRange " + nextRange + "   startIndex:" + startIndex + "  endIndex:" + endIndex);
            if (endIndex < nextRange.getStartIndex()) break;
            tailSetIt.remove();
            this.indicesCount -= nextRange.getLength();
            if (endIndex >= nextRange.getEndIndex()) continue;
            endIndex = nextRange.getEndIndex();
            break;
        }
        this.add(startIndex, endIndex);
    }

    synchronized void remove(Range range) {
        if (range.isEmpty()) {
            return;
        }
        long startIndex = range.getStartIndex();
        long endIndex = range.getEndIndex();
        SortedSet<Range> headSet = this.ranges.headSet(range);
        if (headSet.size() > 0) {
            Range previousRange = headSet.last();
            LOG.debug("previousRange " + previousRange);
            if (startIndex < previousRange.getEndIndex()) {
                if (this.ranges.remove(previousRange)) {
                    this.indicesCount -= previousRange.getLength();
                    LOG.debug("removed previousRange " + previousRange);
                }
                this.add(previousRange.getStartIndex(), startIndex);
                if (endIndex <= previousRange.getEndIndex()) {
                    this.add(endIndex, previousRange.getEndIndex());
                }
            }
        }
        Iterator tailSetIt = this.ranges.tailSet(range).iterator();
        while (tailSetIt.hasNext()) {
            Range nextRange = (Range)tailSetIt.next();
            LOG.debug("nextRange " + nextRange + "   startIndex:" + startIndex + "  endIndex:" + endIndex);
            if (endIndex <= nextRange.getStartIndex()) break;
            tailSetIt.remove();
            this.indicesCount -= nextRange.getLength();
            if (endIndex >= nextRange.getEndIndex()) continue;
            this.add(endIndex, nextRange.getEndIndex());
            break;
        }
    }

    private void add(long start, long end) {
        if (end > start) {
            Range recRange = new Range(start, end - start);
            this.ranges.add(recRange);
            this.indicesCount += recRange.getLength();
            LOG.debug("added " + recRange);
        }
    }

    public synchronized void readFields(DataInput in) throws IOException {
        this.indicesCount = in.readLong();
        this.ranges = new TreeSet();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Range range = new Range();
            range.readFields(in);
            this.ranges.add(range);
        }
    }

    public synchronized void write(DataOutput out) throws IOException {
        out.writeLong(this.indicesCount);
        out.writeInt(this.ranges.size());
        for (Range range : this.ranges) {
            range.write(out);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Range range : this.ranges) {
            sb.append(range.toString() + "\n");
        }
        return sb.toString();
    }

    static class SkipRangeIterator
    implements Iterator<Long> {
        Iterator<Range> rangeIterator;
        Range range = new Range();
        long next = -1L;

        SkipRangeIterator(Iterator<Range> rangeIterator) {
            this.rangeIterator = rangeIterator;
            this.doNext();
        }

        @Override
        public synchronized boolean hasNext() {
            return this.next < Long.MAX_VALUE;
        }

        @Override
        public synchronized Long next() {
            long ci = this.next;
            this.doNext();
            return ci;
        }

        private void doNext() {
            ++this.next;
            LOG.debug("currentIndex " + this.next + "   " + this.range);
            this.skipIfInRange();
            while (this.next >= this.range.getEndIndex() && this.rangeIterator.hasNext()) {
                this.range = this.rangeIterator.next();
                this.skipIfInRange();
            }
        }

        private void skipIfInRange() {
            if (this.next >= this.range.getStartIndex() && this.next < this.range.getEndIndex()) {
                LOG.warn("Skipping index " + this.next + "-" + this.range.getEndIndex());
                this.next = this.range.getEndIndex();
            }
        }

        synchronized boolean skippedAllRanges() {
            return !this.rangeIterator.hasNext() && this.next > this.range.getEndIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported.");
        }
    }

    static class Range
    implements Comparable<Range>,
    Writable {
        private long startIndex;
        private long length;

        Range(long startIndex, long length) {
            if (length < 0L) {
                throw new RuntimeException("length can't be negative");
            }
            this.startIndex = startIndex;
            this.length = length;
        }

        Range() {
            this(0L, 0L);
        }

        long getStartIndex() {
            return this.startIndex;
        }

        long getEndIndex() {
            return this.startIndex + this.length;
        }

        long getLength() {
            return this.length;
        }

        boolean isEmpty() {
            return this.length == 0L;
        }

        public boolean equals(Object o) {
            if (o instanceof Range) {
                Range range = (Range)o;
                return this.startIndex == range.startIndex && this.length == range.length;
            }
            return false;
        }

        public int hashCode() {
            return Long.valueOf(this.startIndex).hashCode() + Long.valueOf(this.length).hashCode();
        }

        @Override
        public int compareTo(Range o) {
            return this.startIndex < o.startIndex ? -1 : (this.startIndex > o.startIndex ? 1 : (this.length < o.length ? -1 : (this.length > o.length ? 1 : 0)));
        }

        public void readFields(DataInput in) throws IOException {
            this.startIndex = in.readLong();
            this.length = in.readLong();
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.startIndex);
            out.writeLong(this.length);
        }

        public String toString() {
            return this.startIndex + ":" + this.length;
        }
    }
}

