/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.AutoValue_FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.annotations.SchemaCaseFormat;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldNumber;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
@Internal
public abstract class FieldValueTypeInformation
implements Serializable {
    public abstract @Nullable @UnknownKeyFor @Initialized Integer getNumber();

    public abstract @UnknownKeyFor @NonNull @Initialized String getName();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean isNullable();

    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getType();

    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getRawType();

    public abstract @Nullable @UnknownKeyFor @Initialized Field getField();

    public abstract @Nullable @UnknownKeyFor @Initialized Method getMethod();

    public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> getOneOfTypes();

    public abstract @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getElementType();

    public abstract @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getMapKeyType();

    public abstract @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getMapValueType();

    public abstract @Nullable @UnknownKeyFor @Initialized String getDescription();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forOneOf(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized boolean nullable, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> oneOfTypes) {
        TypeDescriptor<OneOfType.Value> typeDescriptor = TypeDescriptor.of(OneOfType.Value.class);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(typeDescriptor).setRawType(typeDescriptor.getRawType()).setField(null).setElementType(null).setMapKeyType(null).setMapValueType(null).setOneOfTypes(oneOfTypes).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forField(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Field field, @UnknownKeyFor @NonNull @Initialized int index) {
        TypeDescriptor type = Optional.ofNullable(typeDescriptor).map(td -> td.resolveType(field.getGenericType())).orElseGet(() -> TypeDescriptor.of(field.getGenericType()));
        return new AutoValue_FieldValueTypeInformation.Builder().setName(FieldValueTypeInformation.getNameOverride(field.getName(), field)).setNumber(FieldValueTypeInformation.getNumberOverride(index, field)).setNullable(FieldValueTypeInformation.hasNullableAnnotation(field)).setType(type).setRawType(type.getRawType()).setField(field).setElementType(FieldValueTypeInformation.getIterableComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).setOneOfTypes(Collections.emptyMap()).setDescription(FieldValueTypeInformation.getFieldDescription(field)).build();
    }

    public static <T extends AnnotatedElement & Member> @UnknownKeyFor @NonNull @Initialized int getNumberOverride(@UnknownKeyFor @NonNull @Initialized int index, T member) {
        @Nullable SchemaFieldNumber fieldNumber = member.getAnnotation(SchemaFieldNumber.class);
        if (fieldNumber == null) {
            return index;
        }
        return Integer.parseInt(fieldNumber.value());
    }

    public static <T extends AnnotatedElement & Member> @UnknownKeyFor @NonNull @Initialized String getNameOverride(@UnknownKeyFor @NonNull @Initialized String original, T member) {
        @Nullable SchemaFieldName fieldName = member.getAnnotation(SchemaFieldName.class);
        @Nullable SchemaCaseFormat caseFormatAnnotation = member.getAnnotation(SchemaCaseFormat.class);
        @Nullable SchemaCaseFormat classCaseFormatAnnotation = ((Member)member).getDeclaringClass().getAnnotation(SchemaCaseFormat.class);
        if (fieldName != null) {
            if (caseFormatAnnotation != null) {
                throw new RuntimeException(String.format("Cannot define both @SchemaFieldName and @SchemaCaseFormat. From member '%s'.", ((Member)member).getName()));
            }
            return fieldName.value();
        }
        if (caseFormatAnnotation != null) {
            return CaseFormat.LOWER_CAMEL.to(caseFormatAnnotation.value(), original);
        }
        if (classCaseFormatAnnotation != null) {
            return CaseFormat.LOWER_CAMEL.to(classCaseFormatAnnotation.value(), original);
        }
        return original;
    }

    public static <T extends AnnotatedElement & Member> @Nullable @UnknownKeyFor @Initialized String getFieldDescription(T member) {
        @Nullable SchemaFieldDescription fieldDescription = member.getAnnotation(SchemaFieldDescription.class);
        if (fieldDescription == null) {
            return null;
        }
        return fieldDescription.value();
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forGetter(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized int index) {
        return FieldValueTypeInformation.forGetter(null, method, index);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forGetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized int index) {
        String name;
        if (method.getName().startsWith("get")) {
            name = ReflectUtils.stripPrefix(method.getName(), "get");
        } else if (method.getName().startsWith("is")) {
            name = ReflectUtils.stripPrefix(method.getName(), "is");
        } else {
            throw new RuntimeException("Getter has wrong prefix " + method.getName());
        }
        TypeDescriptor type = Optional.ofNullable(typeDescriptor).map(td -> td.resolveType(method.getGenericReturnType())).orElseGet(() -> TypeDescriptor.of(method.getGenericReturnType()));
        boolean nullable = FieldValueTypeInformation.hasNullableReturnType(method);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(FieldValueTypeInformation.getNameOverride(name, method)).setNumber(FieldValueTypeInformation.getNumberOverride(index, method)).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getIterableComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).setOneOfTypes(Collections.emptyMap()).setDescription(FieldValueTypeInformation.getFieldDescription(method)).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNullableAnnotation(@UnknownKeyFor @NonNull @Initialized Field field) {
        Stream<Annotation> annotations = Stream.concat(Stream.of(field.getAnnotations()), Stream.of(field.getAnnotatedType().getAnnotations()));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNullableReturnType(@UnknownKeyFor @NonNull @Initialized Method method) {
        Stream<Annotation> annotations = Stream.concat(Stream.of(method.getAnnotations()), Stream.of(method.getAnnotatedReturnType().getAnnotations()));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasSingleNullableParameter(@UnknownKeyFor @NonNull @Initialized Method method) {
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("Setter methods should take a single argument " + method.getName());
        }
        Stream<Annotation> annotations = Stream.concat(Arrays.stream(method.getAnnotatedParameterTypes()[0].getAnnotations()), Arrays.stream(method.getParameterAnnotations()[0]));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNullableAnnotation(@UnknownKeyFor @NonNull @Initialized Annotation annotation) {
        return annotation.annotationType().getSimpleName().equals("Nullable");
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forSetter(@UnknownKeyFor @NonNull @Initialized Method method) {
        return FieldValueTypeInformation.forSetter(null, method);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forSetter(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized String setterPrefix) {
        return FieldValueTypeInformation.forSetter(null, method, setterPrefix);
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forSetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Method method) {
        return FieldValueTypeInformation.forSetter(typeDescriptor, method, "set");
    }

    public static @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation forSetter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized String setterPrefix) {
        if (!method.getName().startsWith(setterPrefix)) {
            throw new RuntimeException("Setter has wrong prefix " + method.getName());
        }
        String name = ReflectUtils.stripPrefix(method.getName(), setterPrefix);
        TypeDescriptor type = Optional.ofNullable(typeDescriptor).map(td -> td.resolveType(method.getGenericParameterTypes()[0])).orElseGet(() -> TypeDescriptor.of(method.getGenericParameterTypes()[0]));
        boolean nullable = FieldValueTypeInformation.hasSingleNullableParameter(method);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getIterableComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).setOneOfTypes(Collections.emptyMap()).build();
    }

    public @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation withName(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.toBuilder().setName(name).build();
    }

    static @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getIterableComponentType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueType) {
        TypeDescriptor componentType = ReflectUtils.getIterableComponentType(valueType);
        if (componentType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(componentType).setRawType(componentType.getRawType()).setElementType(FieldValueTypeInformation.getIterableComponentType(componentType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(componentType)).setMapValueType(FieldValueTypeInformation.getMapValueType(componentType)).setOneOfTypes(Collections.emptyMap()).build();
    }

    private static @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getMapKeyType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 0);
    }

    private static @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getMapValueType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 1);
    }

    private static @Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation getMapType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> valueType, @UnknownKeyFor @NonNull @Initialized int index) {
        TypeDescriptor mapType = ReflectUtils.getMapType(valueType, index);
        if (mapType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(mapType).setRawType(mapType.getRawType()).setElementType(FieldValueTypeInformation.getIterableComponentType(mapType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(mapType)).setMapValueType(FieldValueTypeInformation.getMapValueType(mapType)).setOneOfTypes(Collections.emptyMap()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumber(@Nullable @UnknownKeyFor @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setName(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNullable(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setType(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setRawType(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setField(@Nullable @UnknownKeyFor @Initialized Field var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMethod(@Nullable @UnknownKeyFor @Initialized Method var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setOneOfTypes(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setElementType(@Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMapKeyType(@Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMapValueType(@Nullable @UnknownKeyFor @Initialized FieldValueTypeInformation var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDescription(@Nullable @UnknownKeyFor @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation build();
    }
}

