/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SimpleContentConstructor;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public abstract class XSLStringConstructor
extends StyleElement {
    protected Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void validate() throws XPathException {
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty");
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (this.select == null) {
            if (nodeInfo == null) {
                this.select = StringValue.EMPTY_STRING;
            } else if (axisIterator.next() == null && nodeInfo.getNodeKind() == 3) {
                this.select = StringValue.makeStringValue(nodeInfo.getStringValueCS());
            }
        }
    }

    protected void compileContent(Executable executable, SimpleNodeConstructor simpleNodeConstructor, Expression expression) throws XPathException {
        if (expression == null) {
            expression = StringValue.SINGLE_SPACE;
        }
        try {
            if (this.select != null) {
                simpleNodeConstructor.setSelect(new SimpleContentConstructor(this.select, expression).simplify(this.getStaticContext()), executable.getConfiguration());
            } else {
                Expression expression2 = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
                simpleNodeConstructor.setSelect(new SimpleContentConstructor(expression2, expression).simplify(this.getStaticContext()), executable.getConfiguration());
            }
        }
        catch (StaticError staticError) {
            this.compileError(staticError);
        }
    }
}

